/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.AncientCityStructurePieces;
import net.minecraft.data.worldgen.BastionPieces;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.PillagerOutpostPools;
import net.minecraft.data.worldgen.TrailRuinsStructurePools;
import net.minecraft.data.worldgen.TrialChambersStructurePools;
import net.minecraft.data.worldgen.VillagePools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class Pools {
    public static final ResourceKey<StructureTemplatePool> EMPTY = Pools.createKey("empty");

    public static ResourceKey<StructureTemplatePool> createKey(ResourceLocation p_380323_) {
        return ResourceKey.create(Registries.TEMPLATE_POOL, p_380323_);
    }

    public static ResourceKey<StructureTemplatePool> createKey(String p_256439_) {
        return Pools.createKey(ResourceLocation.withDefaultNamespace(p_256439_));
    }

    public static ResourceKey<StructureTemplatePool> parseKey(String p_350360_) {
        return Pools.createKey(ResourceLocation.parse(p_350360_));
    }

    public static void register(BootstrapContext<StructureTemplatePool> p_321699_, String p_255837_, StructureTemplatePool p_256161_) {
        p_321699_.register(Pools.createKey(p_255837_), p_256161_);
    }

    public static void bootstrap(BootstrapContext<StructureTemplatePool> p_321867_) {
        HolderGetter<StructureTemplatePool> holdergetter = p_321867_.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> holder = holdergetter.getOrThrow(EMPTY);
        p_321867_.register(EMPTY, new StructureTemplatePool(holder, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(), StructureTemplatePool.Projection.RIGID));
        BastionPieces.bootstrap(p_321867_);
        PillagerOutpostPools.bootstrap(p_321867_);
        VillagePools.bootstrap(p_321867_);
        AncientCityStructurePieces.bootstrap(p_321867_);
        TrailRuinsStructurePools.bootstrap(p_321867_);
        TrialChambersStructurePools.bootstrap(p_321867_);
    }
}

