/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public abstract class TagsProvider<T>
implements DataProvider {
    protected final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final CompletableFuture<Void> contentsDone = new CompletableFuture();
    private final CompletableFuture<TagLookup<T>> parentProvider;
    protected final ResourceKey<? extends Registry<T>> registryKey;
    protected final Map<ResourceLocation, TagBuilder> builders = Maps.newLinkedHashMap();
    protected final String modId;

    @Deprecated
    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_) {
        this(p_256596_, p_255886_, p_256513_, "vanilla");
    }

    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_, String modId) {
        this(p_256596_, p_255886_, p_256513_, CompletableFuture.completedFuture(TagLookup.empty()), modId);
    }

    @Deprecated
    protected TagsProvider(PackOutput p_275432_, ResourceKey<? extends Registry<T>> p_275476_, CompletableFuture<HolderLookup.Provider> p_275222_, CompletableFuture<TagLookup<T>> p_275565_) {
        this(p_275432_, p_275476_, p_275222_, p_275565_, "vanilla");
    }

    protected TagsProvider(PackOutput p_275432_, ResourceKey<? extends Registry<T>> p_275476_, CompletableFuture<HolderLookup.Provider> p_275222_, CompletableFuture<TagLookup<T>> p_275565_, String modId) {
        this.pathProvider = p_275432_.createRegistryTagsPathProvider(p_275476_);
        this.registryKey = p_275476_;
        this.parentProvider = p_275565_;
        this.lookupProvider = p_275222_;
        this.modId = modId;
    }

    @Nullable
    protected Path getPath(ResourceLocation id) {
        return this.pathProvider.json(id);
    }

    @Override
    public String getName() {
        return "Tags for " + String.valueOf(this.registryKey.location()) + " mod id " + this.modId;
    }

    protected abstract void addTags(HolderLookup.Provider var1);

    @Override
    public CompletableFuture<?> run(CachedOutput p_253684_) {
        record CombinedData<T>(HolderLookup.Provider contents, TagLookup<T> parent) {
        }
        return ((CompletableFuture)((CompletableFuture)this.createContentsProvider().thenApply(p_275895_ -> {
            this.contentsDone.complete(null);
            return p_275895_;
        })).thenCombineAsync(this.parentProvider, (p_274778_, p_274779_) -> new CombinedData((HolderLookup.Provider)p_274778_, p_274779_), (Executor)Util.backgroundExecutor())).thenCompose(p_323140_ -> {
            HolderGetter registrylookup = p_323140_.contents.lookupOrThrow(this.registryKey);
            Predicate<ResourceLocation> predicate = arg_0 -> this.lambda$run$2((HolderLookup.RegistryLookup)registrylookup, arg_0);
            Predicate<ResourceLocation> predicate1 = p_274776_ -> this.builders.containsKey(p_274776_) || p_323140_.parent.contains(TagKey.create(this.registryKey, p_274776_));
            return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(p_323138_ -> {
                ResourceLocation resourcelocation = (ResourceLocation)p_323138_.getKey();
                TagBuilder tagbuilder = (TagBuilder)p_323138_.getValue();
                List<TagEntry> list = tagbuilder.build();
                List<TagEntry> list1 = Stream.concat(list.stream(), tagbuilder.getRemoveEntries()).filter(p_274771_ -> p_274771_.getId().getNamespace().equals(this.modId) && !p_274771_.verifyIfPresent(predicate, predicate1)).toList();
                if (!list1.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", resourcelocation, list1.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                Path path = this.getPath(resourcelocation);
                if (path == null) {
                    return CompletableFuture.completedFuture(null);
                }
                List<TagEntry> removed = tagbuilder.getRemoveEntries().toList();
                return DataProvider.saveStable(p_253684_, p_323140_.contents, TagFile.CODEC, new TagFile(list, tagbuilder.isReplace(), removed), path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected TagBuilder getOrCreateRawBuilder(TagKey<T> p_236452_) {
        return this.builders.computeIfAbsent(p_236452_.location(), p_236442_ -> TagBuilder.create());
    }

    public CompletableFuture<TagLookup<T>> contentsGetter() {
        return this.contentsDone.thenApply(p_276016_ -> p_274772_ -> Optional.ofNullable(this.builders.get(p_274772_.location())));
    }

    protected CompletableFuture<HolderLookup.Provider> createContentsProvider() {
        return this.lookupProvider.thenApply(p_274768_ -> {
            this.builders.clear();
            this.addTags((HolderLookup.Provider)p_274768_);
            return p_274768_;
        });
    }

    private /* synthetic */ boolean lambda$run$2(HolderLookup.RegistryLookup registrylookup, ResourceLocation p_255496_) {
        return registrylookup.get(ResourceKey.create(this.registryKey, p_255496_)).isPresent();
    }

    @FunctionalInterface
    public static interface TagLookup<T>
    extends Function<TagKey<T>, Optional<TagBuilder>> {
        public static <T> TagLookup<T> empty() {
            return p_275247_ -> Optional.empty();
        }

        default public boolean contains(TagKey<T> p_275413_) {
            return ((Optional)this.apply(p_275413_)).isPresent();
        }
    }
}

