/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public interface RecipeBuilder {
    public static final ResourceLocation ROOT_RECIPE_ADVANCEMENT = ResourceLocation.withDefaultNamespace("recipes/root");

    public RecipeBuilder unlockedBy(String var1, Criterion<?> var2);

    public RecipeBuilder group(@Nullable String var1);

    public Item getResult();

    public void save(RecipeOutput var1, ResourceKey<Recipe<?>> var2);

    default public void save(RecipeOutput p_301244_) {
        this.save(p_301244_, ResourceKey.create(Registries.RECIPE, RecipeBuilder.getDefaultRecipeId(this.getResult())));
    }

    default public void save(RecipeOutput p_301186_, String p_176502_) {
        ResourceLocation resourcelocation = RecipeBuilder.getDefaultRecipeId(this.getResult());
        ResourceLocation resourcelocation1 = ResourceLocation.parse(p_176502_);
        if (resourcelocation1.equals(resourcelocation)) {
            throw new IllegalStateException("Recipe " + p_176502_ + " should remove its 'save' argument as it is equal to default one");
        }
        this.save(p_301186_, ResourceKey.create(Registries.RECIPE, resourcelocation1));
    }

    public static ResourceLocation getDefaultRecipeId(ItemLike p_176494_) {
        return BuiltInRegistries.ITEM.getKey(p_176494_.asItem());
    }

    public static CraftingBookCategory determineBookCategory(RecipeCategory p_311837_) {
        return switch (p_311837_) {
            case RecipeCategory.BUILDING_BLOCKS -> CraftingBookCategory.BUILDING;
            case RecipeCategory.TOOLS, RecipeCategory.COMBAT -> CraftingBookCategory.EQUIPMENT;
            case RecipeCategory.REDSTONE -> CraftingBookCategory.REDSTONE;
            default -> CraftingBookCategory.MISC;
        };
    }
}

