/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import org.slf4j.Logger;

public class LootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceKey<LootTable>> requiredTables;
    private final List<SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootTableProvider(PackOutput p_254123_, Set<ResourceKey<LootTable>> p_254481_, List<SubProviderEntry> p_253798_, CompletableFuture<HolderLookup.Provider> p_323798_) {
        this.pathProvider = p_254123_.createRegistryElementsPathProvider(Registries.LOOT_TABLE);
        this.subProviders = p_253798_;
        this.requiredTables = p_254481_;
        this.registries = p_323798_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_254060_) {
        return this.registries.thenCompose(p_323117_ -> this.run(p_254060_, (HolderLookup.Provider)p_323117_));
    }

    private CompletableFuture<?> run(CachedOutput p_324447_, HolderLookup.Provider p_323978_) {
        MappedRegistry<LootTable> writableregistry = new MappedRegistry<LootTable>(Registries.LOOT_TABLE, Lifecycle.experimental());
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        IdentityHashMap conditionsPerTable = new IdentityHashMap();
        this.getTables().forEach(arg_0 -> LootTableProvider.lambda$run$2(p_323978_, (Map)map, writableregistry, conditionsPerTable, arg_0));
        writableregistry.freeze();
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        RegistryAccess.Frozen holdergetter$provider = new RegistryAccess.ImmutableRegistryAccess(List.of(writableregistry)).freeze();
        ValidationContext validationcontext = new ValidationContext(problemreporter$collector, LootContextParamSets.ALL_PARAMS, holdergetter$provider);
        this.validate(writableregistry, validationcontext, problemreporter$collector);
        if (!problemreporter$collector.isEmpty()) {
            problemreporter$collector.forEach((p_421299_, p_421300_) -> LOGGER.warn("Found validation problem in {}: {}", p_421299_, (Object)p_421300_.description()));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])writableregistry.entrySet().stream().map(p_335193_ -> {
            ResourceKey resourcekey1 = (ResourceKey)p_335193_.getKey();
            LootTable loottable = (LootTable)p_335193_.getValue();
            Path path = this.pathProvider.json(resourcekey1.location());
            WithConditions conditional = new WithConditions(conditionsPerTable.getOrDefault(loottable, List.of()), (Object)loottable);
            return DataProvider.saveStable(p_324447_, p_323978_, LootTable.CONDITIONAL_DIRECT_CODEC, Optional.of(conditional), path);
        }).toArray(CompletableFuture[]::new));
    }

    public List<SubProviderEntry> getTables() {
        return this.subProviders;
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        for (ResourceKey resourcekey : Sets.difference(this.requiredTables, writableregistry.registryKeySet())) {
            problemreporter$collector.report(new MissingTableProblem(resourcekey));
        }
        writableregistry.listElements().forEach(p_380823_ -> ((LootTable)p_380823_.value()).validate(validationcontext.setContextKeySet(((LootTable)p_380823_.value()).getParamSet()).enterElement(new ProblemReporter.RootElementPathElement(p_380823_.key()), p_380823_.key())));
    }

    private static ResourceLocation sequenceIdForLootTable(ResourceKey<LootTable> p_336172_) {
        return p_336172_.location();
    }

    @Override
    public final String getName() {
        return "Loot Tables";
    }

    private static /* synthetic */ void lambda$run$2(HolderLookup.Provider p_323978_, Map map, WritableRegistry writableregistry, Map conditionsPerTable, SubProviderEntry p_344197_) {
        p_344197_.provider().apply(p_323978_).generate((p_380827_, p_380828_) -> {
            ResourceLocation resourcelocation = LootTableProvider.sequenceIdForLootTable(p_380827_);
            ResourceLocation resourcelocation1 = map.put(RandomSequence.seedForKey(resourcelocation), resourcelocation);
            if (resourcelocation1 != null) {
                Util.logAndPauseIfInIde("Loot table random sequence seed collision on " + String.valueOf(resourcelocation1) + " and " + String.valueOf(p_380827_.location()));
            }
            p_380828_.setRandomSequence(resourcelocation);
            LootTable loottable = p_380828_.setParamSet(p_344197_.paramSet).build();
            writableregistry.register(p_380827_, loottable, RegistrationInfo.BUILT_IN);
            List<ICondition> conditions = p_380828_.buildConditions();
            if (!conditions.isEmpty()) {
                conditionsPerTable.put(loottable, conditions);
            }
        });
    }

    public record MissingTableProblem(ResourceKey<LootTable> id) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Missing built-in table: " + String.valueOf(this.id.location());
        }
    }

    public record SubProviderEntry(Function<HolderLookup.Provider, LootTableSubProvider> provider, ContextKeySet paramSet) {
    }
}

