/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTypes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockListReport
implements DataProvider {
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public BlockListReport(PackOutput p_251533_, CompletableFuture<HolderLookup.Provider> p_330926_) {
        this.output = p_251533_;
        this.registries = p_330926_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_236197_) {
        Path path = this.output.getOutputFolder(PackOutput.Target.REPORTS).resolve("blocks.json");
        return this.registries.thenCompose(p_367817_ -> {
            JsonObject jsonobject = new JsonObject();
            RegistryOps registryops = p_367817_.createSerializationContext(JsonOps.INSTANCE);
            p_367817_.lookupOrThrow(Registries.BLOCK).listElements().forEach(p_330336_ -> {
                JsonObject jsonobject1 = new JsonObject();
                StateDefinition<Block, BlockState> statedefinition = ((Block)p_330336_.value()).getStateDefinition();
                if (!statedefinition.getProperties().isEmpty()) {
                    JsonObject jsonobject2 = new JsonObject();
                    for (Property property : statedefinition.getProperties()) {
                        JsonArray jsonarray = new JsonArray();
                        for (Comparable comparable : property.getPossibleValues()) {
                            jsonarray.add(Util.getPropertyName(property, comparable));
                        }
                        jsonobject2.add(property.getName(), (JsonElement)jsonarray);
                    }
                    jsonobject1.add("properties", (JsonElement)jsonobject2);
                }
                JsonArray jsonarray1 = new JsonArray();
                for (BlockState blockState : statedefinition.getPossibleStates()) {
                    JsonObject jsonobject3 = new JsonObject();
                    JsonObject jsonobject4 = new JsonObject();
                    for (Property<?> property1 : statedefinition.getProperties()) {
                        jsonobject4.addProperty(property1.getName(), Util.getPropertyName(property1, blockState.getValue(property1)));
                    }
                    if (jsonobject4.size() > 0) {
                        jsonobject3.add("properties", (JsonElement)jsonobject4);
                    }
                    jsonobject3.addProperty("id", (Number)Block.getId(blockState));
                    if (blockState == ((Block)p_330336_.value()).defaultBlockState()) {
                        jsonobject3.addProperty("default", Boolean.valueOf(true));
                    }
                    jsonarray1.add((JsonElement)jsonobject3);
                }
                jsonobject1.add("states", (JsonElement)jsonarray1);
                String s = p_330336_.getRegisteredName();
                JsonElement jsonElement = (JsonElement)BlockTypes.CODEC.codec().encodeStart((DynamicOps)registryops, (Object)((Block)p_330336_.value())).getOrThrow(p_331670_ -> new AssertionError((Object)("Failed to serialize block " + s + " (is type registered in BlockTypes?): " + p_331670_)));
                jsonobject1.add("definition", jsonElement);
                jsonobject.add(s, (JsonElement)jsonobject1);
            });
            return DataProvider.saveStable(p_236197_, (JsonElement)jsonobject, path);
        });
    }

    @Override
    public final String getName() {
        return "Block List";
    }
}

