/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import org.slf4j.Logger;

public class ShulkerBoxDispenseBehavior
extends OptionalDispenseItemBehavior {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    protected ItemStack execute(BlockSource p_302426_, ItemStack p_123588_) {
        this.setSuccess(false);
        Item item = p_123588_.getItem();
        if (item instanceof BlockItem) {
            Direction direction = p_302426_.state().getValue(DispenserBlock.FACING);
            BlockPos blockpos = p_302426_.pos().relative(direction);
            Direction direction1 = p_302426_.level().isEmptyBlock(blockpos.below()) ? direction : Direction.UP;
            try {
                this.setSuccess(((BlockItem)item).place(new DirectionalPlaceContext((Level)p_302426_.level(), blockpos, direction, p_123588_, direction1)).consumesAction());
            }
            catch (Exception exception) {
                LOGGER.error("Error trying to place shulker box at {}", (Object)blockpos, (Object)exception);
            }
        }
        return p_123588_;
    }
}

