/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.block.DispenserBlock;

public class ProjectileDispenseBehavior
extends DefaultDispenseItemBehavior {
    private final ProjectileItem projectileItem;
    private final ProjectileItem.DispenseConfig dispenseConfig;

    public ProjectileDispenseBehavior(Item p_338781_) {
        ProjectileItem projectileitem;
        if (!(p_338781_ instanceof ProjectileItem)) {
            throw new IllegalArgumentException(String.valueOf(p_338781_) + " not instance of " + ProjectileItem.class.getSimpleName());
        }
        this.projectileItem = projectileitem = (ProjectileItem)((Object)p_338781_);
        this.dispenseConfig = projectileitem.createDispenseConfig();
    }

    @Override
    public ItemStack execute(BlockSource p_338635_, ItemStack p_338423_) {
        ServerLevel serverlevel = p_338635_.level();
        Direction direction = p_338635_.state().getValue(DispenserBlock.FACING);
        Position position = this.dispenseConfig.positionFunction().getDispensePosition(p_338635_, direction);
        Projectile.spawnProjectileUsingShoot(this.projectileItem.asProjectile(serverlevel, position, p_338423_, direction), serverlevel, p_338423_, direction.getStepX(), direction.getStepY(), direction.getStepZ(), this.dispenseConfig.power(), this.dispenseConfig.uncertainty());
        p_338423_.shrink(1);
        return p_338423_;
    }

    @Override
    protected void playSound(BlockSource p_338184_) {
        p_338184_.level().levelEvent(this.dispenseConfig.overrideDispenseEvent().orElse(1002), p_338184_.pos(), 0);
    }
}

