/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.neoforged.neoforge.common.CommonHooks;

public final class DataComponentPatch {
    public static final DataComponentPatch EMPTY = new DataComponentPatch(Reference2ObjectMaps.emptyMap());
    public static final Codec<DataComponentPatch> CODEC = Codec.dispatchedMap(PatchKey.CODEC, PatchKey::valueCodec).xmap(p_330885_ -> {
        if (p_330885_.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(p_330885_.size());
        for (Map.Entry entry : p_330885_.entrySet()) {
            PatchKey datacomponentpatch$patchkey = (PatchKey)entry.getKey();
            if (datacomponentpatch$patchkey.removed()) {
                reference2objectmap.put(datacomponentpatch$patchkey.type(), Optional.empty());
                continue;
            }
            reference2objectmap.put(datacomponentpatch$patchkey.type(), Optional.of(entry.getValue()));
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
    }, p_332132_ -> {
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(p_332132_.map.size());
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(p_332132_.map)) {
            DataComponentType datacomponenttype = (DataComponentType)entry.getKey();
            if (datacomponenttype.isTransient()) continue;
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                reference2objectmap.put((Object)new PatchKey(datacomponenttype, false), optional.get());
                continue;
            }
            reference2objectmap.put((Object)new PatchKey(datacomponenttype, true), (Object)Unit.INSTANCE);
        }
        return reference2objectmap;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> STREAM_CODEC = DataComponentPatch.createStreamCodec(new CodecGetter(){

        public <T> StreamCodec<RegistryFriendlyByteBuf, T> apply(DataComponentType<T> p_412084_) {
            return p_412084_.streamCodec().cast();
        }
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> DELIMITED_STREAM_CODEC = DataComponentPatch.createStreamCodec(new CodecGetter(){

        public <T> StreamCodec<RegistryFriendlyByteBuf, T> apply(DataComponentType<T> p_412362_) {
            StreamCodec streamcodec = p_412362_.streamCodec().cast();
            return streamcodec.apply(ByteBufCodecs.registryFriendlyLengthPrefixed(Integer.MAX_VALUE));
        }
    });
    private static final String REMOVED_PREFIX = "!";
    final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map;

    private static StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> createStreamCodec(final CodecGetter p_412279_) {
        return new StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch>(){

            @Override
            public DataComponentPatch decode(RegistryFriendlyByteBuf p_412537_) {
                int i = p_412537_.readVarInt();
                int j = p_412537_.readVarInt();
                if (i == 0 && j == 0) {
                    return EMPTY;
                }
                int k = i + j;
                Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(Math.min(k, 65536));
                for (int l = 0; l < i; ++l) {
                    DataComponentType datacomponenttype = (DataComponentType)DataComponentType.STREAM_CODEC.decode(p_412537_);
                    Object object = p_412279_.apply(datacomponenttype).decode(p_412537_);
                    reference2objectmap.put((Object)datacomponenttype, Optional.of(object));
                }
                for (int i1 = 0; i1 < j; ++i1) {
                    DataComponentType datacomponenttype1 = (DataComponentType)DataComponentType.STREAM_CODEC.decode(p_412537_);
                    reference2objectmap.put((Object)datacomponenttype1, Optional.empty());
                }
                return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf p_412402_, DataComponentPatch p_412784_) {
                if (p_412784_.isEmpty()) {
                    p_412402_.writeVarInt(0);
                    p_412402_.writeVarInt(0);
                } else {
                    int i = 0;
                    int j = 0;
                    for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(p_412784_.map)) {
                        if (((Optional)entry.getValue()).isPresent()) {
                            ++i;
                            continue;
                        }
                        ++j;
                    }
                    p_412402_.writeVarInt(i);
                    p_412402_.writeVarInt(j);
                    for (Reference2ObjectMap.Entry entry1 : Reference2ObjectMaps.fastIterable(p_412784_.map)) {
                        Optional optional = (Optional)entry1.getValue();
                        if (!optional.isPresent()) continue;
                        DataComponentType datacomponenttype = (DataComponentType)entry1.getKey();
                        DataComponentType.STREAM_CODEC.encode(p_412402_, datacomponenttype);
                        this.encodeComponent(p_412402_, datacomponenttype, optional.get());
                    }
                    for (Reference2ObjectMap.Entry entry2 : Reference2ObjectMaps.fastIterable(p_412784_.map)) {
                        if (!((Optional)entry2.getValue()).isEmpty()) continue;
                        DataComponentType datacomponenttype1 = (DataComponentType)entry2.getKey();
                        DataComponentType.STREAM_CODEC.encode(p_412402_, datacomponenttype1);
                    }
                }
            }

            private <T> void encodeComponent(RegistryFriendlyByteBuf p_412610_, DataComponentType<T> p_412314_, Object p_412095_) {
                p_412279_.apply(p_412314_).encode(p_412610_, p_412095_);
            }
        };
    }

    DataComponentPatch(Reference2ObjectMap<DataComponentType<?>, Optional<?>> p_331816_) {
        this.map = p_331816_;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public <T> Optional<? extends T> get(DataComponentType<? extends T> p_331532_) {
        return (Optional)this.map.get(p_331532_);
    }

    public Set<Map.Entry<DataComponentType<?>, Optional<?>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public DataComponentPatch forget(Predicate<DataComponentType<?>> p_338629_) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(this.map);
        reference2objectmap.keySet().removeIf(p_338629_);
        return reference2objectmap.isEmpty() ? EMPTY : new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public SplitResult split() {
        if (this.isEmpty()) {
            return SplitResult.EMPTY;
        }
        DataComponentMap.Builder datacomponentmap$builder = DataComponentMap.builder();
        Set set = Sets.newIdentityHashSet();
        this.map.forEach((p_337451_, p_337452_) -> {
            if (p_337452_.isPresent()) {
                datacomponentmap$builder.setUnchecked(p_337451_, p_337452_.get());
            } else {
                set.add(p_337451_);
            }
        });
        return new SplitResult(datacomponentmap$builder.build(), set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_331686_) {
        if (this == p_331686_) {
            return true;
        }
        if (!(p_331686_ instanceof DataComponentPatch)) return false;
        DataComponentPatch datacomponentpatch = (DataComponentPatch)p_331686_;
        if (!this.map.equals(datacomponentpatch.map)) return false;
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return DataComponentPatch.toString(this.map);
    }

    static String toString(Reference2ObjectMap<DataComponentType<?>, Optional<?>> p_330935_) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append('{');
        boolean flag = true;
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(p_330935_)) {
            if (flag) {
                flag = false;
            } else {
                stringbuilder.append(", ");
            }
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                stringbuilder.append(entry.getKey());
                stringbuilder.append("=>");
                stringbuilder.append(optional.get());
                continue;
            }
            stringbuilder.append(REMOVED_PREFIX);
            stringbuilder.append(entry.getKey());
        }
        stringbuilder.append('}');
        return stringbuilder.toString();
    }

    @FunctionalInterface
    static interface CodecGetter {
        public <T> StreamCodec<? super RegistryFriendlyByteBuf, T> apply(DataComponentType<T> var1);
    }

    public static class Builder {
        private final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map = new Reference2ObjectArrayMap();

        Builder() {
        }

        public <T> Builder set(DataComponentType<T> p_332004_, T p_331566_) {
            CommonHooks.validateComponent(p_331566_);
            this.map.put(p_332004_, Optional.of(p_331566_));
            return this;
        }

        public <T> Builder remove(DataComponentType<T> p_330845_) {
            this.map.put(p_330845_, Optional.empty());
            return this;
        }

        public <T> Builder set(TypedDataComponent<T> p_331321_) {
            return this.set(p_331321_.type(), p_331321_.value());
        }

        public DataComponentPatch build() {
            return this.map.isEmpty() ? EMPTY : new DataComponentPatch(this.map);
        }
    }

    public record SplitResult(DataComponentMap added, Set<DataComponentType<?>> removed) {
        public static final SplitResult EMPTY = new SplitResult(DataComponentMap.EMPTY, Set.of());
    }

    record PatchKey(DataComponentType<?> type, boolean removed) {
        public static final Codec<PatchKey> CODEC = Codec.STRING.flatXmap(p_330929_ -> {
            ResourceLocation resourcelocation;
            DataComponentType<?> datacomponenttype;
            boolean flag = p_330929_.startsWith(DataComponentPatch.REMOVED_PREFIX);
            if (flag) {
                p_330929_ = p_330929_.substring(DataComponentPatch.REMOVED_PREFIX.length());
            }
            if ((datacomponenttype = BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(resourcelocation = ResourceLocation.tryParse(p_330929_))) == null) {
                return DataResult.error(() -> "No component with type: '" + String.valueOf(resourcelocation) + "'");
            }
            return datacomponenttype.isTransient() ? DataResult.error(() -> "'" + String.valueOf(resourcelocation) + "' is not a persistent component") : DataResult.success((Object)new PatchKey(datacomponenttype, flag));
        }, p_339345_ -> {
            DataComponentType<?> datacomponenttype = p_339345_.type();
            ResourceLocation resourcelocation = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(datacomponenttype);
            return resourcelocation == null ? DataResult.error(() -> "Unregistered component: " + String.valueOf(datacomponenttype)) : DataResult.success((Object)(p_339345_.removed() ? DataComponentPatch.REMOVED_PREFIX + String.valueOf(resourcelocation) : resourcelocation.toString()));
        });

        public Codec<?> valueCodec() {
            return this.removed ? Codec.EMPTY.codec() : this.type.codecOrThrow();
        }
    }
}

