/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.repository.KnownPack;

public class RegistrySynchronization {
    private static final Set<ResourceKey<? extends Registry<?>>> NETWORKABLE_REGISTRIES = RegistryDataLoader.SYNCHRONIZED_REGISTRIES.stream().map(RegistryDataLoader.RegistryData::key).collect(Collectors.toUnmodifiableSet());

    public static void packRegistries(DynamicOps<Tag> p_321796_, RegistryAccess p_321733_, Set<KnownPack> p_326143_, BiConsumer<ResourceKey<? extends Registry<?>>, List<PackedRegistryEntry>> p_321539_) {
        RegistryDataLoader.SYNCHRONIZED_REGISTRIES.forEach(p_325532_ -> RegistrySynchronization.packRegistry(p_321796_, p_325532_, p_321733_, p_326143_, p_321539_));
    }

    private static <T> void packRegistry(DynamicOps<Tag> p_321608_, RegistryDataLoader.RegistryData<T> p_321701_, RegistryAccess p_321717_, Set<KnownPack> p_326432_, BiConsumer<ResourceKey<? extends Registry<?>>, List<PackedRegistryEntry>> p_321724_) {
        p_321717_.lookup(p_321701_.key()).ifPresent(p_367812_ -> {
            ArrayList list = new ArrayList(p_367812_.size());
            p_367812_.listElements().forEach(p_325522_ -> {
                Optional<Tag> optional;
                boolean flag = p_367812_.registrationInfo(p_325522_.key()).flatMap(RegistrationInfo::knownPackInfo).filter(p_326432_::contains).isPresent();
                if (flag) {
                    optional = Optional.empty();
                } else {
                    Tag tag = (Tag)p_321701_.elementCodec().encodeStart(p_321608_, p_325522_.value()).getOrThrow(p_339341_ -> new IllegalArgumentException("Failed to serialize " + String.valueOf(p_325522_.key()) + ": " + p_339341_));
                    optional = Optional.of(tag);
                }
                list.add(new PackedRegistryEntry(p_325522_.key().location(), optional));
            });
            p_321724_.accept(p_367812_.key(), list);
        });
    }

    private static Stream<RegistryAccess.RegistryEntry<?>> ownedNetworkableRegistries(RegistryAccess p_251842_) {
        return p_251842_.registries().filter(p_359340_ -> RegistrySynchronization.isNetworkable(p_359340_.key()));
    }

    public static Stream<RegistryAccess.RegistryEntry<?>> networkedRegistries(LayeredRegistryAccess<RegistryLayer> p_259290_) {
        return RegistrySynchronization.ownedNetworkableRegistries(p_259290_.getAccessFrom(RegistryLayer.WORLDGEN));
    }

    public static Stream<RegistryAccess.RegistryEntry<?>> networkSafeRegistries(LayeredRegistryAccess<RegistryLayer> p_249066_) {
        Stream<RegistryAccess.RegistryEntry<?>> stream = p_249066_.getLayer(RegistryLayer.STATIC).registries();
        Stream<RegistryAccess.RegistryEntry<?>> stream1 = RegistrySynchronization.networkedRegistries(p_249066_);
        return Stream.concat(stream1, stream);
    }

    public static boolean isNetworkable(ResourceKey<? extends Registry<?>> p_364744_) {
        return NETWORKABLE_REGISTRIES.contains(p_364744_);
    }

    public record PackedRegistryEntry(ResourceLocation id, Optional<Tag> data) {
        public static final StreamCodec<ByteBuf, PackedRegistryEntry> STREAM_CODEC = StreamCodec.composite(ResourceLocation.STREAM_CODEC, PackedRegistryEntry::id, ByteBufCodecs.TAG.apply(ByteBufCodecs::optional), PackedRegistryEntry::data, PackedRegistryEntry::new);
    }
}

