/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;

public interface RegistryAccess
extends HolderLookup.Provider {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Frozen EMPTY = new ImmutableRegistryAccess(Map.of()).freeze();

    public <E> Optional<Registry<E>> lookup(ResourceKey<? extends Registry<? extends E>> var1);

    default public <E> Registry<E> lookupOrThrow(ResourceKey<? extends Registry<? extends E>> p_368620_) {
        return this.lookup(p_368620_).orElseThrow(() -> new IllegalStateException("Missing registry: " + String.valueOf(p_368620_)));
    }

    public Stream<RegistryEntry<?>> registries();

    @Override
    default public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
        return this.registries().map(p_359339_ -> p_359339_.key);
    }

    public static Frozen fromRegistryOfRegistries(final Registry<? extends Registry<?>> p_206166_) {
        return new Frozen(){

            public <T> Optional<Registry<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_206220_) {
                Registry registry = p_206166_;
                return registry.getOptional(p_206220_);
            }

            @Override
            public Stream<RegistryEntry<?>> registries() {
                return p_206166_.entrySet().stream().map(RegistryEntry::fromMapEntry);
            }

            @Override
            public Frozen freeze() {
                return this;
            }
        };
    }

    default public Frozen freeze() {
        class FrozenAccess
        extends ImmutableRegistryAccess
        implements Frozen {
            protected FrozenAccess(RegistryAccess this$0, Stream<RegistryEntry<?>> p_252031_) {
                super(p_252031_);
            }
        }
        return new FrozenAccess(this, this.registries().map(RegistryEntry::freeze));
    }

    public record RegistryEntry<T>(ResourceKey<? extends Registry<T>> key, Registry<T> value) {
        private static <T, R extends Registry<? extends T>> RegistryEntry<T> fromMapEntry(Map.Entry<? extends ResourceKey<? extends Registry<?>>, R> p_206242_) {
            return RegistryEntry.fromUntyped(p_206242_.getKey(), (Registry)p_206242_.getValue());
        }

        private static <T> RegistryEntry<T> fromUntyped(ResourceKey<? extends Registry<?>> p_206244_, Registry<?> p_206245_) {
            return new RegistryEntry(p_206244_, p_206245_);
        }

        private RegistryEntry<T> freeze() {
            return new RegistryEntry<T>(this.key, this.value.freeze());
        }
    }

    public static class ImmutableRegistryAccess
    implements RegistryAccess {
        private final Map<? extends ResourceKey<? extends Registry<?>>, ? extends Registry<?>> registries;

        public ImmutableRegistryAccess(List<? extends Registry<?>> p_248540_) {
            this.registries = p_248540_.stream().collect(Collectors.toUnmodifiableMap(Registry::key, p_247993_ -> p_247993_));
        }

        public ImmutableRegistryAccess(Map<? extends ResourceKey<? extends Registry<?>>, ? extends Registry<?>> p_206225_) {
            this.registries = Map.copyOf(p_206225_);
        }

        public ImmutableRegistryAccess(Stream<RegistryEntry<?>> p_206227_) {
            this.registries = (Map)p_206227_.collect(ImmutableMap.toImmutableMap(RegistryEntry::key, RegistryEntry::value));
        }

        @Override
        public <E> Optional<Registry<E>> lookup(ResourceKey<? extends Registry<? extends E>> p_206229_) {
            return Optional.ofNullable(this.registries.get(p_206229_)).map(p_206232_ -> p_206232_);
        }

        @Override
        public Stream<RegistryEntry<?>> registries() {
            return this.registries.entrySet().stream().map(RegistryEntry::fromMapEntry);
        }
    }

    public static interface Frozen
    extends RegistryAccess {
    }
}

