/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class SuggestionProviders {
    private static final Map<ResourceLocation, SuggestionProvider<SharedSuggestionProvider>> PROVIDERS_BY_NAME = new HashMap<ResourceLocation, SuggestionProvider<SharedSuggestionProvider>>();
    private static final ResourceLocation ID_ASK_SERVER = ResourceLocation.withDefaultNamespace("ask_server");
    public static final SuggestionProvider<SharedSuggestionProvider> ASK_SERVER = SuggestionProviders.register(ID_ASK_SERVER, (SuggestionProvider<SharedSuggestionProvider>)((SuggestionProvider)(p_121673_, p_121674_) -> ((SharedSuggestionProvider)p_121673_.getSource()).customSuggestion(p_121673_)));
    public static final SuggestionProvider<SharedSuggestionProvider> AVAILABLE_SOUNDS = SuggestionProviders.register(ResourceLocation.withDefaultNamespace("available_sounds"), (SuggestionProvider<SharedSuggestionProvider>)((SuggestionProvider)(p_121667_, p_121668_) -> SharedSuggestionProvider.suggestResource(((SharedSuggestionProvider)p_121667_.getSource()).getAvailableSounds(), p_121668_)));
    public static final SuggestionProvider<SharedSuggestionProvider> SUMMONABLE_ENTITIES = SuggestionProviders.register(ResourceLocation.withDefaultNamespace("summonable_entities"), (SuggestionProvider<SharedSuggestionProvider>)((SuggestionProvider)(p_359328_, p_359329_) -> SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.stream().filter(p_247987_ -> p_247987_.isEnabled(((SharedSuggestionProvider)p_359328_.getSource()).enabledFeatures()) && p_247987_.canSummon()), p_359329_, EntityType::getKey, EntityType::getDescription)));

    public static <S extends SharedSuggestionProvider> SuggestionProvider<S> register(ResourceLocation p_121659_, SuggestionProvider<SharedSuggestionProvider> p_121660_) {
        SuggestionProvider<SharedSuggestionProvider> suggestionprovider = PROVIDERS_BY_NAME.putIfAbsent(p_121659_, p_121660_);
        if (suggestionprovider != null) {
            throw new IllegalArgumentException("A command suggestion provider is already registered with the name '" + String.valueOf(p_121659_) + "'");
        }
        return new RegisteredSuggestion(p_121659_, p_121660_);
    }

    public static <S extends SharedSuggestionProvider> SuggestionProvider<S> cast(SuggestionProvider<SharedSuggestionProvider> p_426085_) {
        return p_426085_;
    }

    public static <S extends SharedSuggestionProvider> SuggestionProvider<S> getProvider(ResourceLocation p_121657_) {
        return SuggestionProviders.cast(PROVIDERS_BY_NAME.getOrDefault(p_121657_, ASK_SERVER));
    }

    public static ResourceLocation getName(SuggestionProvider<?> p_121655_) {
        ResourceLocation resourceLocation;
        if (p_121655_ instanceof RegisteredSuggestion) {
            RegisteredSuggestion suggestionproviders$registeredsuggestion = (RegisteredSuggestion)p_121655_;
            resourceLocation = suggestionproviders$registeredsuggestion.name;
        } else {
            resourceLocation = ID_ASK_SERVER;
        }
        return resourceLocation;
    }

    record RegisteredSuggestion(ResourceLocation name, SuggestionProvider<SharedSuggestionProvider> delegate) implements SuggestionProvider<SharedSuggestionProvider>
    {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<SharedSuggestionProvider> p_425736_, SuggestionsBuilder p_425858_) throws CommandSyntaxException {
            return this.delegate.getSuggestions(p_425736_, p_425858_);
        }
    }
}

