/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.commands.PermissionCheck;
import org.slf4j.Logger;

public class ArgumentUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final byte NUMBER_FLAG_MIN = 1;
    private static final byte NUMBER_FLAG_MAX = 2;

    public static int createNumberFlags(boolean p_235428_, boolean p_235429_) {
        int i = 0;
        if (p_235428_) {
            i |= 1;
        }
        if (p_235429_) {
            i |= 2;
        }
        return i;
    }

    public static boolean numberHasMin(byte p_235403_) {
        return (p_235403_ & 1) != 0;
    }

    public static boolean numberHasMax(byte p_235431_) {
        return (p_235431_ & 2) != 0;
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeArgumentCap(JsonObject p_235411_, ArgumentTypeInfo<A, T> p_235412_, ArgumentTypeInfo.Template<A> p_235413_) {
        p_235412_.serializeToJson(p_235413_, p_235411_);
    }

    private static <T extends ArgumentType<?>> void serializeArgumentToJson(JsonObject p_235405_, T p_235406_) {
        ArgumentTypeInfo.Template<T> template = ArgumentTypeInfos.unpack(p_235406_);
        p_235405_.addProperty("type", "argument");
        p_235405_.addProperty("parser", String.valueOf(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getKey(template.type())));
        JsonObject jsonobject = new JsonObject();
        ArgumentUtils.serializeArgumentCap(jsonobject, template.type(), template);
        if (!jsonobject.isEmpty()) {
            p_235405_.add("properties", (JsonElement)jsonobject);
        }
    }

    public static <S> JsonObject serializeNodeToJson(CommandDispatcher<S> p_235415_, CommandNode<S> p_235416_) {
        Collection collection1;
        Object rootcommandnode;
        JsonObject jsonobject = new JsonObject();
        CommandNode<S> commandNode = p_235416_;
        Objects.requireNonNull(commandNode);
        CommandNode<S> commandNode2 = commandNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RootCommandNode.class, LiteralCommandNode.class, ArgumentCommandNode.class}, commandNode2, n)) {
            case 0: {
                rootcommandnode = (RootCommandNode)commandNode2;
                jsonobject.addProperty("type", "root");
                break;
            }
            case 1: {
                LiteralCommandNode literalcommandnode = (LiteralCommandNode)commandNode2;
                jsonobject.addProperty("type", "literal");
                break;
            }
            case 2: {
                ArgumentCommandNode argumentcommandnode = (ArgumentCommandNode)commandNode2;
                ArgumentUtils.serializeArgumentToJson(jsonobject, argumentcommandnode.getType());
                break;
            }
            default: {
                LOGGER.error("Could not serialize node {} ({})!", p_235416_, p_235416_.getClass());
                jsonobject.addProperty("type", "unknown");
            }
        }
        Collection collection = p_235416_.getChildren();
        if (!collection.isEmpty()) {
            JsonObject jsonobject1 = new JsonObject();
            rootcommandnode = collection.iterator();
            while (rootcommandnode.hasNext()) {
                CommandNode commandnode = (CommandNode)rootcommandnode.next();
                jsonobject1.add(commandnode.getName(), (JsonElement)ArgumentUtils.serializeNodeToJson(p_235415_, commandnode));
            }
            jsonobject.add("children", (JsonElement)jsonobject1);
        }
        if (p_235416_.getCommand() != null) {
            jsonobject.addProperty("executable", Boolean.valueOf(true));
        }
        if ((rootcommandnode = p_235416_.getRequirement()) instanceof PermissionCheck) {
            PermissionCheck permissioncheck = (PermissionCheck)rootcommandnode;
            jsonobject.addProperty("required_level", (Number)permissioncheck.requiredLevel());
        }
        if (p_235416_.getRedirect() != null && !(collection1 = p_235415_.getPath(p_235416_.getRedirect())).isEmpty()) {
            JsonArray jsonarray = new JsonArray();
            for (String s : collection1) {
                jsonarray.add(s);
            }
            jsonobject.add("redirect", (JsonElement)jsonarray);
        }
        return jsonobject;
    }

    public static <T> Set<ArgumentType<?>> findUsedArgumentTypes(CommandNode<T> p_235418_) {
        ReferenceOpenHashSet set = new ReferenceOpenHashSet();
        HashSet set1 = new HashSet();
        ArgumentUtils.findUsedArgumentTypes(p_235418_, set1, set);
        return set1;
    }

    private static <T> void findUsedArgumentTypes(CommandNode<T> p_235420_, Set<ArgumentType<?>> p_235421_, Set<CommandNode<T>> p_235422_) {
        if (p_235422_.add(p_235420_)) {
            if (p_235420_ instanceof ArgumentCommandNode) {
                ArgumentCommandNode argumentcommandnode = (ArgumentCommandNode)p_235420_;
                p_235421_.add(argumentcommandnode.getType());
            }
            p_235420_.getChildren().forEach(p_235426_ -> ArgumentUtils.findUsedArgumentTypes(p_235426_, p_235421_, p_235422_));
            CommandNode commandnode = p_235420_.getRedirect();
            if (commandnode != null) {
                ArgumentUtils.findUsedArgumentTypes(commandnode, p_235421_, p_235422_);
            }
        }
    }
}

