/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CommandQueueEntry;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.EntryAction;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.execution.tasks.ContinuationTask;
import net.minecraft.commands.execution.tasks.ExecuteCommand;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.network.chat.Component;

public class BuildContexts<T extends ExecutionCommandSource<T>> {
    @VisibleForTesting
    public static final DynamicCommandExceptionType ERROR_FORK_LIMIT_REACHED = new DynamicCommandExceptionType(p_306063_ -> Component.translatableEscape("command.forkLimit", p_306063_));
    private final String commandInput;
    private final ContextChain<T> command;

    public BuildContexts(String p_306157_, ContextChain<T> p_305974_) {
        this.commandInput = p_306157_;
        this.command = p_305974_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(T p_309567_, List<T> p_306303_, ExecutionContext<T> p_305977_, Frame p_309603_, ChainModifiers p_309659_) {
        ContextChain contextchain = this.command;
        ChainModifiers chainmodifiers = p_309659_;
        List<Object> list = p_306303_;
        if (contextchain.getStage() != ContextChain.Stage.EXECUTE) {
            p_305977_.profiler().push(() -> "prepare " + this.commandInput);
            try {
                int i = p_305977_.forkLimit();
                while (contextchain.getStage() != ContextChain.Stage.EXECUTE) {
                    RedirectModifier redirectmodifier;
                    CommandContext commandcontext = contextchain.getTopContext();
                    if (commandcontext.isForked()) {
                        chainmodifiers = chainmodifiers.setForked();
                    }
                    if ((redirectmodifier = commandcontext.getRedirectModifier()) instanceof CustomModifierExecutor) {
                        CustomModifierExecutor custommodifierexecutor = (CustomModifierExecutor)redirectmodifier;
                        custommodifierexecutor.apply(p_309567_, list, contextchain, chainmodifiers, ExecutionControl.create(p_305977_, p_309603_));
                        return;
                    }
                    if (redirectmodifier != null) {
                        p_305977_.incrementCost();
                        boolean flag = chainmodifiers.isForked();
                        ObjectArrayList list1 = new ObjectArrayList();
                        for (ExecutionCommandSource executionCommandSource : list) {
                            Collection collection;
                            block22: {
                                try {
                                    collection = ContextChain.runModifier((CommandContext)commandcontext, (Object)executionCommandSource, (p_309424_, p_309425_, p_309426_) -> {}, (boolean)flag);
                                    if (list1.size() + collection.size() < i) break block22;
                                    p_309567_.handleError(ERROR_FORK_LIMIT_REACHED.create((Object)i), flag, p_305977_.tracer());
                                    return;
                                }
                                catch (CommandSyntaxException commandsyntaxexception) {
                                    executionCommandSource.handleError(commandsyntaxexception, flag, p_305977_.tracer());
                                    if (flag) continue;
                                    p_305977_.profiler().pop();
                                    return;
                                }
                            }
                            list1.addAll(collection);
                        }
                        list = list1;
                    }
                    contextchain = contextchain.nextStage();
                }
            }
            finally {
                p_305977_.profiler().pop();
            }
        }
        if (list.isEmpty()) {
            if (chainmodifiers.isReturn()) {
                p_305977_.queueNext(new CommandQueueEntry(p_309603_, FallthroughTask.instance()));
            }
        } else {
            CommandContext commandcontext1 = contextchain.getTopContext();
            Command command = commandcontext1.getCommand();
            if (command instanceof CustomCommandExecutor) {
                CustomCommandExecutor customcommandexecutor = (CustomCommandExecutor)command;
                ExecutionControl executioncontrol = ExecutionControl.create(p_305977_, p_309603_);
                for (ExecutionCommandSource executionCommandSource : list) {
                    customcommandexecutor.run(executionCommandSource, contextchain, chainmodifiers, executioncontrol);
                }
            } else {
                if (chainmodifiers.isReturn()) {
                    ExecutionCommandSource t1 = (ExecutionCommandSource)list.get(0);
                    t1 = t1.withCallback(CommandResultCallback.chain(t1.callback(), p_309603_.returnValueConsumer()));
                    list = List.of(t1);
                }
                ExecuteCommand executecommand = new ExecuteCommand(this.commandInput, chainmodifiers, commandcontext1);
                ContinuationTask.schedule(p_305977_, p_309603_, list, (p_309428_, p_309429_) -> new CommandQueueEntry<ExecutionCommandSource>(p_309428_, executecommand.bind(p_309429_)));
            }
        }
    }

    protected void traceCommandStart(ExecutionContext<T> p_306237_, Frame p_309625_) {
        TraceCallbacks tracecallbacks = p_306237_.tracer();
        if (tracecallbacks != null) {
            tracecallbacks.onCommand(p_309625_.depth(), this.commandInput);
        }
    }

    public String toString() {
        return this.commandInput;
    }

    public static class Unbound<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements UnboundEntryAction<T> {
        public Unbound(String p_305863_, ContextChain<T> p_305842_) {
            super(p_305863_, p_305842_);
        }

        @Override
        public void execute(T p_306259_, ExecutionContext<T> p_305944_, Frame p_309714_) {
            this.traceCommandStart(p_305944_, p_309714_);
            this.execute(p_306259_, List.of(p_306259_), p_305944_, p_309714_, ChainModifiers.DEFAULT);
        }
    }

    public static class TopLevel<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements EntryAction<T> {
        private final T source;

        public TopLevel(String p_306314_, ContextChain<T> p_305844_, T p_306134_) {
            super(p_306314_, p_305844_);
            this.source = p_306134_;
        }

        @Override
        public void execute(ExecutionContext<T> p_306114_, Frame p_309583_) {
            this.traceCommandStart(p_306114_, p_309583_);
            this.execute(this.source, List.of(this.source), p_306114_, p_309583_, ChainModifiers.DEFAULT);
        }
    }

    public static class Continuation<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements EntryAction<T> {
        private final ChainModifiers modifiers;
        private final T originalSource;
        private final List<T> sources;

        public Continuation(String p_306217_, ContextChain<T> p_305988_, ChainModifiers p_309702_, T p_309701_, List<T> p_306017_) {
            super(p_306217_, p_305988_);
            this.originalSource = p_309701_;
            this.sources = p_306017_;
            this.modifiers = p_309702_;
        }

        @Override
        public void execute(ExecutionContext<T> p_305882_, Frame p_309577_) {
            this.execute(this.originalSource, this.sources, p_305882_, p_309577_, this.modifiers);
        }
    }
}

