/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.WrappedMinMaxBounds;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;
import org.slf4j.Logger;

public class EntitySelectorOptions {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, Option> OPTIONS = Maps.newHashMap();
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_OPTION = new DynamicCommandExceptionType(p_304141_ -> Component.translatableEscape("argument.entity.options.unknown", p_304141_));
    public static final DynamicCommandExceptionType ERROR_INAPPLICABLE_OPTION = new DynamicCommandExceptionType(p_304138_ -> Component.translatableEscape("argument.entity.options.inapplicable", p_304138_));
    public static final SimpleCommandExceptionType ERROR_RANGE_NEGATIVE = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType ERROR_LEVEL_NEGATIVE = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType ERROR_LIMIT_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType ERROR_SORT_UNKNOWN = new DynamicCommandExceptionType(p_304139_ -> Component.translatableEscape("argument.entity.options.sort.irreversible", p_304139_));
    public static final DynamicCommandExceptionType ERROR_GAME_MODE_INVALID = new DynamicCommandExceptionType(p_304140_ -> Component.translatableEscape("argument.entity.options.mode.invalid", p_304140_));
    public static final DynamicCommandExceptionType ERROR_ENTITY_TYPE_INVALID = new DynamicCommandExceptionType(p_304137_ -> Component.translatableEscape("argument.entity.options.type.invalid", p_304137_));

    public static void register(String p_121454_, Modifier p_121455_, Predicate<EntitySelectorParser> p_121456_, Component p_121457_) {
        OPTIONS.put(p_121454_, new Option(p_121455_, p_121456_, p_121457_));
    }

    public static void bootStrap() {
        if (OPTIONS.isEmpty()) {
            EntitySelectorOptions.register("name", p_360473_ -> {
                int i = p_360473_.getReader().getCursor();
                boolean flag = p_360473_.shouldInvertValue();
                String s = p_360473_.getReader().readString();
                if (p_360473_.hasNameNotEquals() && !flag) {
                    p_360473_.getReader().setCursor(i);
                    throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)p_360473_.getReader(), (Object)"name");
                }
                if (flag) {
                    p_360473_.setHasNameNotEquals(true);
                } else {
                    p_360473_.setHasNameEquals(true);
                }
                p_360473_.addPredicate(p_175209_ -> p_175209_.getName().getString().equals(s) != flag);
            }, p_121423_ -> !p_121423_.hasNameEquals(), Component.translatable("argument.entity.options.name.description"));
            EntitySelectorOptions.register("distance", p_422466_ -> {
                int i = p_422466_.getReader().getCursor();
                MinMaxBounds.Doubles minmaxbounds$doubles = MinMaxBounds.Doubles.fromReader(p_422466_.getReader());
                if (minmaxbounds$doubles.min().isPresent() && minmaxbounds$doubles.min().get() < 0.0 || minmaxbounds$doubles.max().isPresent() && minmaxbounds$doubles.max().get() < 0.0) {
                    p_422466_.getReader().setCursor(i);
                    throw ERROR_RANGE_NEGATIVE.createWithContext((ImmutableStringReader)p_422466_.getReader());
                }
                p_422466_.setDistance(minmaxbounds$doubles);
                p_422466_.setWorldLimited();
            }, p_121419_ -> p_121419_.getDistance().isAny(), Component.translatable("argument.entity.options.distance.description"));
            EntitySelectorOptions.register("level", p_121417_ -> {
                int i = p_121417_.getReader().getCursor();
                MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromReader(p_121417_.getReader());
                if (minmaxbounds$ints.min().isPresent() && minmaxbounds$ints.min().get() < 0 || minmaxbounds$ints.max().isPresent() && minmaxbounds$ints.max().get() < 0) {
                    p_121417_.getReader().setCursor(i);
                    throw ERROR_LEVEL_NEGATIVE.createWithContext((ImmutableStringReader)p_121417_.getReader());
                }
                p_121417_.setLevel(minmaxbounds$ints);
                p_121417_.setIncludesEntities(false);
            }, p_121415_ -> p_121415_.getLevel().isAny(), Component.translatable("argument.entity.options.level.description"));
            EntitySelectorOptions.register("x", p_121413_ -> {
                p_121413_.setWorldLimited();
                p_121413_.setX(p_121413_.getReader().readDouble());
            }, p_121411_ -> p_121411_.getX() == null, Component.translatable("argument.entity.options.x.description"));
            EntitySelectorOptions.register("y", p_121409_ -> {
                p_121409_.setWorldLimited();
                p_121409_.setY(p_121409_.getReader().readDouble());
            }, p_121407_ -> p_121407_.getY() == null, Component.translatable("argument.entity.options.y.description"));
            EntitySelectorOptions.register("z", p_121405_ -> {
                p_121405_.setWorldLimited();
                p_121405_.setZ(p_121405_.getReader().readDouble());
            }, p_121403_ -> p_121403_.getZ() == null, Component.translatable("argument.entity.options.z.description"));
            EntitySelectorOptions.register("dx", p_121401_ -> {
                p_121401_.setWorldLimited();
                p_121401_.setDeltaX(p_121401_.getReader().readDouble());
            }, p_121399_ -> p_121399_.getDeltaX() == null, Component.translatable("argument.entity.options.dx.description"));
            EntitySelectorOptions.register("dy", p_121397_ -> {
                p_121397_.setWorldLimited();
                p_121397_.setDeltaY(p_121397_.getReader().readDouble());
            }, p_121395_ -> p_121395_.getDeltaY() == null, Component.translatable("argument.entity.options.dy.description"));
            EntitySelectorOptions.register("dz", p_121562_ -> {
                p_121562_.setWorldLimited();
                p_121562_.setDeltaZ(p_121562_.getReader().readDouble());
            }, p_121560_ -> p_121560_.getDeltaZ() == null, Component.translatable("argument.entity.options.dz.description"));
            EntitySelectorOptions.register("x_rotation", p_121558_ -> p_121558_.setRotX(WrappedMinMaxBounds.fromReader(p_121558_.getReader(), true, Mth::wrapDegrees)), p_121556_ -> p_121556_.getRotX() == WrappedMinMaxBounds.ANY, Component.translatable("argument.entity.options.x_rotation.description"));
            EntitySelectorOptions.register("y_rotation", p_121554_ -> p_121554_.setRotY(WrappedMinMaxBounds.fromReader(p_121554_.getReader(), true, Mth::wrapDegrees)), p_121552_ -> p_121552_.getRotY() == WrappedMinMaxBounds.ANY, Component.translatable("argument.entity.options.y_rotation.description"));
            EntitySelectorOptions.register("limit", p_121550_ -> {
                int i = p_121550_.getReader().getCursor();
                int j = p_121550_.getReader().readInt();
                if (j < 1) {
                    p_121550_.getReader().setCursor(i);
                    throw ERROR_LIMIT_TOO_SMALL.createWithContext((ImmutableStringReader)p_121550_.getReader());
                }
                p_121550_.setMaxResults(j);
                p_121550_.setLimited(true);
            }, p_121548_ -> !p_121548_.isCurrentEntity() && !p_121548_.isLimited(), Component.translatable("argument.entity.options.limit.description"));
            EntitySelectorOptions.register("sort", p_247983_ -> {
                int i = p_247983_.getReader().getCursor();
                String s = p_247983_.getReader().readUnquotedString();
                p_247983_.setSuggestions((p_175153_, p_175154_) -> SharedSuggestionProvider.suggest(Arrays.asList("nearest", "furthest", "random", "arbitrary"), p_175153_));
                p_247983_.setOrder(switch (s) {
                    case "nearest" -> EntitySelectorParser.ORDER_NEAREST;
                    case "furthest" -> EntitySelectorParser.ORDER_FURTHEST;
                    case "random" -> EntitySelectorParser.ORDER_RANDOM;
                    case "arbitrary" -> EntitySelector.ORDER_ARBITRARY;
                    default -> {
                        p_247983_.getReader().setCursor(i);
                        throw ERROR_SORT_UNKNOWN.createWithContext((ImmutableStringReader)p_247983_.getReader(), (Object)s);
                    }
                });
                p_247983_.setSorted(true);
            }, p_121544_ -> !p_121544_.isCurrentEntity() && !p_121544_.isSorted(), Component.translatable("argument.entity.options.sort.description"));
            EntitySelectorOptions.register("gamemode", p_412865_ -> {
                p_412865_.setSuggestions((p_175193_, p_175194_) -> {
                    String s1 = p_175193_.getRemaining().toLowerCase(Locale.ROOT);
                    boolean flag1 = !p_412865_.hasGamemodeNotEquals();
                    boolean flag2 = true;
                    if (!s1.isEmpty()) {
                        if (s1.charAt(0) == '!') {
                            flag1 = false;
                            s1 = s1.substring(1);
                        } else {
                            flag2 = false;
                        }
                    }
                    for (GameType gametype1 : GameType.values()) {
                        if (!gametype1.getName().toLowerCase(Locale.ROOT).startsWith(s1)) continue;
                        if (flag2) {
                            p_175193_.suggest("!" + gametype1.getName());
                        }
                        if (!flag1) continue;
                        p_175193_.suggest(gametype1.getName());
                    }
                    return p_175193_.buildFuture();
                });
                int i = p_412865_.getReader().getCursor();
                boolean flag = p_412865_.shouldInvertValue();
                if (p_412865_.hasGamemodeNotEquals() && !flag) {
                    p_412865_.getReader().setCursor(i);
                    throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)p_412865_.getReader(), (Object)"gamemode");
                }
                String s = p_412865_.getReader().readUnquotedString();
                GameType gametype = GameType.byName(s, null);
                if (gametype == null) {
                    p_412865_.getReader().setCursor(i);
                    throw ERROR_GAME_MODE_INVALID.createWithContext((ImmutableStringReader)p_412865_.getReader(), (Object)s);
                }
                p_412865_.setIncludesEntities(false);
                p_412865_.addPredicate(p_412864_ -> {
                    if (p_412864_ instanceof ServerPlayer) {
                        ServerPlayer serverplayer = (ServerPlayer)p_412864_;
                        GameType gametype1 = serverplayer.gameMode();
                        return gametype1 == gametype ^ flag;
                    }
                    return false;
                });
                if (flag) {
                    p_412865_.setHasGamemodeNotEquals(true);
                } else {
                    p_412865_.setHasGamemodeEquals(true);
                }
            }, p_121540_ -> !p_121540_.hasGamemodeEquals(), Component.translatable("argument.entity.options.gamemode.description"));
            EntitySelectorOptions.register("team", p_121538_ -> {
                boolean flag = p_121538_.shouldInvertValue();
                String s = p_121538_.getReader().readUnquotedString();
                p_121538_.addPredicate(p_400873_ -> {
                    PlayerTeam team = p_400873_.getTeam();
                    String s1 = team == null ? "" : ((Team)team).getName();
                    return s1.equals(s) != flag;
                });
                if (flag) {
                    p_121538_.setHasTeamNotEquals(true);
                } else {
                    p_121538_.setHasTeamEquals(true);
                }
            }, p_121536_ -> !p_121536_.hasTeamEquals(), Component.translatable("argument.entity.options.team.description"));
            EntitySelectorOptions.register("type", p_121534_ -> {
                p_121534_.setSuggestions((p_367798_, p_367799_) -> {
                    SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), p_367798_, String.valueOf('!'));
                    SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTags().map(p_359327_ -> p_359327_.key().location()), p_367798_, "!#");
                    if (!p_121534_.isTypeLimitedInversely()) {
                        SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), p_367798_);
                        SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTags().map(p_359326_ -> p_359326_.key().location()), p_367798_, String.valueOf('#'));
                    }
                    return p_367798_.buildFuture();
                });
                int i = p_121534_.getReader().getCursor();
                boolean flag = p_121534_.shouldInvertValue();
                if (p_121534_.isTypeLimitedInversely() && !flag) {
                    p_121534_.getReader().setCursor(i);
                    throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)p_121534_.getReader(), (Object)"type");
                }
                if (flag) {
                    p_121534_.setTypeLimitedInversely();
                }
                if (p_121534_.isTag()) {
                    TagKey<EntityType<?>> tagkey = TagKey.create(Registries.ENTITY_TYPE, ResourceLocation.read(p_121534_.getReader()));
                    p_121534_.addPredicate(p_205691_ -> p_205691_.getType().is(tagkey) != flag);
                } else {
                    ResourceLocation resourcelocation = ResourceLocation.read(p_121534_.getReader());
                    EntityType entitytype = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(resourcelocation).orElseThrow(() -> {
                        p_121534_.getReader().setCursor(i);
                        return ERROR_ENTITY_TYPE_INVALID.createWithContext((ImmutableStringReader)p_121534_.getReader(), (Object)resourcelocation.toString());
                    });
                    if (Objects.equals(EntityType.PLAYER, entitytype) && !flag) {
                        p_121534_.setIncludesEntities(false);
                    }
                    p_121534_.addPredicate(p_175151_ -> Objects.equals(entitytype, p_175151_.getType()) != flag);
                    if (!flag) {
                        p_121534_.limitToType(entitytype);
                    }
                }
            }, p_121532_ -> !p_121532_.isTypeLimited(), Component.translatable("argument.entity.options.type.description"));
            EntitySelectorOptions.register("tag", p_121530_ -> {
                boolean flag = p_121530_.shouldInvertValue();
                String s = p_121530_.getReader().readUnquotedString();
                p_121530_.addPredicate(p_175166_ -> "".equals(s) ? p_175166_.getTags().isEmpty() != flag : p_175166_.getTags().contains(s) != flag);
            }, p_121528_ -> true, Component.translatable("argument.entity.options.tag.description"));
            EntitySelectorOptions.register("nbt", p_399365_ -> {
                boolean flag = p_399365_.shouldInvertValue();
                CompoundTag compoundtag = TagParser.parseCompoundAsArgument(p_399365_.getReader());
                p_399365_.addPredicate(p_421298_ -> {
                    boolean flag1;
                    try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(p_421298_.problemPath(), LOGGER);){
                        ServerPlayer serverplayer;
                        ItemStack itemstack;
                        TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter$scopedcollector, p_421298_.registryAccess());
                        p_421298_.saveWithoutId(tagvalueoutput);
                        if (p_421298_ instanceof ServerPlayer && !(itemstack = (serverplayer = (ServerPlayer)p_421298_).getInventory().getSelectedItem()).isEmpty()) {
                            tagvalueoutput.store("SelectedItem", ItemStack.CODEC, itemstack);
                        }
                        flag1 = NbtUtils.compareNbt(compoundtag, tagvalueoutput.buildResult(), true) != flag;
                    }
                    return flag1;
                });
            }, p_121524_ -> true, Component.translatable("argument.entity.options.nbt.description"));
            EntitySelectorOptions.register("scores", p_121522_ -> {
                StringReader stringreader = p_121522_.getReader();
                HashMap map = Maps.newHashMap();
                stringreader.expect('{');
                stringreader.skipWhitespace();
                while (stringreader.canRead() && stringreader.peek() != '}') {
                    stringreader.skipWhitespace();
                    String s = stringreader.readUnquotedString();
                    stringreader.skipWhitespace();
                    stringreader.expect('=');
                    stringreader.skipWhitespace();
                    MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromReader(stringreader);
                    map.put(s, minmaxbounds$ints);
                    stringreader.skipWhitespace();
                    if (!stringreader.canRead() || stringreader.peek() != ',') continue;
                    stringreader.skip();
                }
                stringreader.expect('}');
                if (!map.isEmpty()) {
                    p_121522_.addPredicate(p_313453_ -> {
                        ServerScoreboard scoreboard = p_313453_.getServer().getScoreboard();
                        for (Map.Entry entry : map.entrySet()) {
                            Objective objective = scoreboard.getObjective((String)entry.getKey());
                            if (objective == null) {
                                return false;
                            }
                            ReadOnlyScoreInfo readonlyscoreinfo = scoreboard.getPlayerScoreInfo((ScoreHolder)p_313453_, objective);
                            if (readonlyscoreinfo == null) {
                                return false;
                            }
                            if (((MinMaxBounds.Ints)entry.getValue()).matches(readonlyscoreinfo.value())) continue;
                            return false;
                        }
                        return true;
                    });
                }
                p_121522_.setHasScores(true);
            }, p_121518_ -> !p_121518_.hasScores(), Component.translatable("argument.entity.options.scores.description"));
            EntitySelectorOptions.register("advancements", p_121514_ -> {
                StringReader stringreader = p_121514_.getReader();
                HashMap map = Maps.newHashMap();
                stringreader.expect('{');
                stringreader.skipWhitespace();
                while (stringreader.canRead() && stringreader.peek() != '}') {
                    stringreader.skipWhitespace();
                    ResourceLocation resourcelocation = ResourceLocation.read(stringreader);
                    stringreader.skipWhitespace();
                    stringreader.expect('=');
                    stringreader.skipWhitespace();
                    if (stringreader.canRead() && stringreader.peek() == '{') {
                        HashMap map1 = Maps.newHashMap();
                        stringreader.skipWhitespace();
                        stringreader.expect('{');
                        stringreader.skipWhitespace();
                        while (stringreader.canRead() && stringreader.peek() != '}') {
                            stringreader.skipWhitespace();
                            String s = stringreader.readUnquotedString();
                            stringreader.skipWhitespace();
                            stringreader.expect('=');
                            stringreader.skipWhitespace();
                            boolean flag1 = stringreader.readBoolean();
                            map1.put(s, p_175186_ -> p_175186_.isDone() == flag1);
                            stringreader.skipWhitespace();
                            if (!stringreader.canRead() || stringreader.peek() != ',') continue;
                            stringreader.skip();
                        }
                        stringreader.skipWhitespace();
                        stringreader.expect('}');
                        stringreader.skipWhitespace();
                        map.put(resourcelocation, p_175169_ -> {
                            for (Map.Entry entry : map1.entrySet()) {
                                CriterionProgress criterionprogress = p_175169_.getCriterion((String)entry.getKey());
                                if (criterionprogress != null && ((Predicate)entry.getValue()).test(criterionprogress)) continue;
                                return false;
                            }
                            return true;
                        });
                    } else {
                        boolean flag = stringreader.readBoolean();
                        map.put(resourcelocation, p_175183_ -> p_175183_.isDone() == flag);
                    }
                    stringreader.skipWhitespace();
                    if (!stringreader.canRead() || stringreader.peek() != ',') continue;
                    stringreader.skip();
                }
                stringreader.expect('}');
                if (!map.isEmpty()) {
                    p_121514_.addPredicate(p_359325_ -> {
                        if (!(p_359325_ instanceof ServerPlayer)) {
                            return false;
                        }
                        ServerPlayer serverplayer = (ServerPlayer)p_359325_;
                        PlayerAdvancements $$4 = serverplayer.getAdvancements();
                        ServerAdvancementManager $$5x = serverplayer.getServer().getAdvancements();
                        for (Map.Entry entry : map.entrySet()) {
                            AdvancementHolder advancementholder = $$5x.get((ResourceLocation)entry.getKey());
                            if (advancementholder != null && ((Predicate)entry.getValue()).test($$4.getOrStartProgress(advancementholder))) continue;
                            return false;
                        }
                        return true;
                    });
                    p_121514_.setIncludesEntities(false);
                }
                p_121514_.setHasAdvancements(true);
            }, p_121506_ -> !p_121506_.hasAdvancements(), Component.translatable("argument.entity.options.advancements.description"));
            EntitySelectorOptions.register("predicate", p_335169_ -> {
                boolean flag = p_335169_.shouldInvertValue();
                ResourceKey<LootItemCondition> resourcekey = ResourceKey.create(Registries.PREDICATE, ResourceLocation.read(p_335169_.getReader()));
                p_335169_.addPredicate(p_367796_ -> {
                    if (!(p_367796_.level() instanceof ServerLevel)) {
                        return false;
                    }
                    ServerLevel serverlevel = (ServerLevel)p_367796_.level();
                    Optional<LootItemCondition> optional = serverlevel.getServer().reloadableRegistries().lookup().get(resourcekey).map(Holder::value);
                    if (optional.isEmpty()) {
                        return false;
                    }
                    LootParams lootparams = new LootParams.Builder(serverlevel).withParameter(LootContextParams.THIS_ENTITY, p_367796_).withParameter(LootContextParams.ORIGIN, p_367796_.position()).create(LootContextParamSets.SELECTOR);
                    LootContext lootcontext = new LootContext.Builder(lootparams).create(Optional.empty());
                    lootcontext.pushVisitedElement(LootContext.createVisitedEntry(optional.get()));
                    return flag ^ optional.get().test(lootcontext);
                });
            }, p_121435_ -> true, Component.translatable("argument.entity.options.predicate.description"));
        }
    }

    public static Modifier get(EntitySelectorParser p_121448_, String p_121449_, int p_121450_) throws CommandSyntaxException {
        Option entityselectoroptions$option = OPTIONS.get(p_121449_);
        if (entityselectoroptions$option != null) {
            if (entityselectoroptions$option.canUse.test(p_121448_)) {
                return entityselectoroptions$option.modifier;
            }
            throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)p_121448_.getReader(), (Object)p_121449_);
        }
        p_121448_.getReader().setCursor(p_121450_);
        throw ERROR_UNKNOWN_OPTION.createWithContext((ImmutableStringReader)p_121448_.getReader(), (Object)p_121449_);
    }

    public static void suggestNames(EntitySelectorParser p_121441_, SuggestionsBuilder p_121442_) {
        String s = p_121442_.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, Option> entry : OPTIONS.entrySet()) {
            if (!entry.getValue().canUse.test(p_121441_) || !entry.getKey().toLowerCase(Locale.ROOT).startsWith(s)) continue;
            p_121442_.suggest(entry.getKey() + "=", (Message)entry.getValue().description);
        }
    }

    record Option(Modifier modifier, Predicate<EntitySelectorParser> canUse, Component description) {
    }

    public static interface Modifier {
        public void handle(EntitySelectorParser var1) throws CommandSyntaxException;
    }
}

