/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;

public record SelectorPattern(String pattern, EntitySelector resolved) {
    public static final Codec<SelectorPattern> CODEC = Codec.STRING.comapFlatMap(SelectorPattern::parse, SelectorPattern::pattern);

    public static DataResult<SelectorPattern> parse(String p_361421_) {
        try {
            EntitySelectorParser entityselectorparser = new EntitySelectorParser(new StringReader(p_361421_), true);
            return DataResult.success((Object)new SelectorPattern(p_361421_, entityselectorparser.parse()));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            return DataResult.error(() -> "Invalid selector component: " + p_361421_ + ": " + commandsyntaxexception.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object p_360529_) {
        if (!(p_360529_ instanceof SelectorPattern)) return false;
        SelectorPattern selectorpattern = (SelectorPattern)p_360529_;
        if (!this.pattern.equals(selectorpattern.pattern)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public String toString() {
        return this.pattern;
    }
}

