/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableObject;

public class ItemParser {
    static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM = new DynamicCommandExceptionType(p_335608_ -> Component.translatableEscape("argument.item.id.invalid", p_335608_));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType(p_335852_ -> Component.translatableEscape("arguments.item.component.unknown", p_335852_));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType((p_336012_, p_335885_) -> Component.translatableEscape("arguments.item.component.malformed", p_336012_, p_335885_));
    static final SimpleCommandExceptionType ERROR_EXPECTED_COMPONENT = new SimpleCommandExceptionType((Message)Component.translatable("arguments.item.component.expected"));
    static final DynamicCommandExceptionType ERROR_REPEATED_COMPONENT = new DynamicCommandExceptionType(p_335753_ -> Component.translatableEscape("arguments.item.component.repeated", p_335753_));
    private static final DynamicCommandExceptionType ERROR_MALFORMED_ITEM = new DynamicCommandExceptionType(p_340618_ -> Component.translatableEscape("arguments.item.malformed", p_340618_));
    public static final char SYNTAX_START_COMPONENTS = '[';
    public static final char SYNTAX_END_COMPONENTS = ']';
    public static final char SYNTAX_COMPONENT_SEPARATOR = ',';
    public static final char SYNTAX_COMPONENT_ASSIGNMENT = '=';
    public static final char SYNTAX_REMOVED_COMPONENT = '!';
    static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    final HolderLookup.RegistryLookup<Item> items;
    final RegistryOps<Tag> registryOps;
    final TagParser<Tag> tagParser;

    public ItemParser(HolderLookup.Provider p_324404_) {
        this.items = p_324404_.lookupOrThrow(Registries.ITEM);
        this.registryOps = p_324404_.createSerializationContext(NbtOps.INSTANCE);
        this.tagParser = TagParser.create(this.registryOps);
    }

    public ItemResult parse(StringReader p_324270_) throws CommandSyntaxException {
        final MutableObject mutableobject = new MutableObject();
        final DataComponentPatch.Builder datacomponentpatch$builder = DataComponentPatch.builder();
        this.parse(p_324270_, new Visitor(){

            @Override
            public void visitItem(Holder<Item> p_324335_) {
                mutableobject.setValue(p_324335_);
            }

            @Override
            public <T> void visitComponent(DataComponentType<T> p_330699_, T p_330996_) {
                datacomponentpatch$builder.set(p_330699_, p_330996_);
            }

            @Override
            public <T> void visitRemovedComponent(DataComponentType<T> p_345362_) {
                datacomponentpatch$builder.remove(p_345362_);
            }
        });
        Holder holder = Objects.requireNonNull((Holder)mutableobject.getValue(), "Parser gave no item");
        DataComponentPatch datacomponentpatch = datacomponentpatch$builder.build();
        ItemParser.validateComponents(p_324270_, holder, datacomponentpatch);
        return new ItemResult(holder, datacomponentpatch);
    }

    private static void validateComponents(StringReader p_341137_, Holder<Item> p_341139_, DataComponentPatch p_345848_) throws CommandSyntaxException {
        PatchedDataComponentMap datacomponentmap = PatchedDataComponentMap.fromPatch(p_341139_.value().components(), p_345848_);
        DataResult<Unit> dataresult = ItemStack.validateComponents(datacomponentmap);
        dataresult.getOrThrow(p_340620_ -> ERROR_MALFORMED_ITEM.createWithContext((ImmutableStringReader)p_341137_, p_340620_));
    }

    public void parse(StringReader p_336039_, Visitor p_335987_) throws CommandSyntaxException {
        int i = p_336039_.getCursor();
        try {
            new State(p_336039_, p_335987_).parse();
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            p_336039_.setCursor(i);
            throw commandsyntaxexception;
        }
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder p_235310_) {
        StringReader stringreader = new StringReader(p_235310_.getInput());
        stringreader.setCursor(p_235310_.getStart());
        SuggestionsVisitor itemparser$suggestionsvisitor = new SuggestionsVisitor();
        State itemparser$state = new State(stringreader, itemparser$suggestionsvisitor);
        try {
            itemparser$state.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return itemparser$suggestionsvisitor.resolveSuggestions(p_235310_, stringreader);
    }

    public static interface Visitor {
        default public void visitItem(Holder<Item> p_336184_) {
        }

        default public <T> void visitComponent(DataComponentType<T> p_336083_, T p_335499_) {
        }

        default public <T> void visitRemovedComponent(DataComponentType<T> p_344835_) {
        }

        default public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> p_335635_) {
        }
    }

    public record ItemResult(Holder<Item> item, DataComponentPatch components) {
    }

    class State {
        private final StringReader reader;
        private final Visitor visitor;

        State(StringReader p_335807_, Visitor p_336013_) {
            this.reader = p_335807_;
            this.visitor = p_336013_;
        }

        public void parse() throws CommandSyntaxException {
            this.visitor.visitSuggestions(this::suggestItem);
            this.readItem();
            this.visitor.visitSuggestions(this::suggestStartComponents);
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.visitor.visitSuggestions(SUGGEST_NOTHING);
                this.readComponents();
            }
        }

        private void readItem() throws CommandSyntaxException {
            int i = this.reader.getCursor();
            ResourceLocation resourcelocation = ResourceLocation.read(this.reader);
            this.visitor.visitItem((Holder<Item>)ItemParser.this.items.get(ResourceKey.create(Registries.ITEM, resourcelocation)).orElseThrow(() -> {
                this.reader.setCursor(i);
                return ERROR_UNKNOWN_ITEM.createWithContext((ImmutableStringReader)this.reader, (Object)resourcelocation);
            }));
        }

        private void readComponents() throws CommandSyntaxException {
            this.reader.expect('[');
            this.visitor.visitSuggestions(this::suggestComponentAssignmentOrRemoval);
            ReferenceArraySet set = new ReferenceArraySet();
            while (this.reader.canRead() && this.reader.peek() != ']') {
                this.reader.skipWhitespace();
                if (this.reader.canRead() && this.reader.peek() == '!') {
                    this.reader.skip();
                    this.visitor.visitSuggestions(this::suggestComponent);
                    DataComponentType<?> datacomponenttype1 = State.readComponentType(this.reader);
                    if (!set.add(datacomponenttype1)) {
                        throw ERROR_REPEATED_COMPONENT.create(datacomponenttype1);
                    }
                    this.visitor.visitRemovedComponent(datacomponenttype1);
                    this.visitor.visitSuggestions(SUGGEST_NOTHING);
                    this.reader.skipWhitespace();
                } else {
                    DataComponentType<?> datacomponenttype = State.readComponentType(this.reader);
                    if (!set.add(datacomponenttype)) {
                        throw ERROR_REPEATED_COMPONENT.create(datacomponenttype);
                    }
                    this.visitor.visitSuggestions(this::suggestAssignment);
                    this.reader.skipWhitespace();
                    this.reader.expect('=');
                    this.visitor.visitSuggestions(SUGGEST_NOTHING);
                    this.reader.skipWhitespace();
                    this.readComponent(ItemParser.this.tagParser, ItemParser.this.registryOps, datacomponenttype);
                    this.reader.skipWhitespace();
                }
                this.visitor.visitSuggestions(this::suggestNextOrEndComponents);
                if (!this.reader.canRead() || this.reader.peek() != ',') break;
                this.reader.skip();
                this.reader.skipWhitespace();
                this.visitor.visitSuggestions(this::suggestComponentAssignmentOrRemoval);
                if (this.reader.canRead()) continue;
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)this.reader);
            }
            this.reader.expect(']');
            this.visitor.visitSuggestions(SUGGEST_NOTHING);
        }

        public static DataComponentType<?> readComponentType(StringReader p_335663_) throws CommandSyntaxException {
            if (!p_335663_.canRead()) {
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)p_335663_);
            }
            int i = p_335663_.getCursor();
            ResourceLocation resourcelocation = ResourceLocation.read(p_335663_);
            DataComponentType<?> datacomponenttype = BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(resourcelocation);
            if (datacomponenttype != null && !datacomponenttype.isTransient()) {
                return datacomponenttype;
            }
            p_335663_.setCursor(i);
            throw ERROR_UNKNOWN_COMPONENT.createWithContext((ImmutableStringReader)p_335663_, (Object)resourcelocation);
        }

        private <T, O> void readComponent(TagParser<O> p_409583_, RegistryOps<O> p_400265_, DataComponentType<T> p_335594_) throws CommandSyntaxException {
            int i = this.reader.getCursor();
            O o = p_409583_.parseAsArgument(this.reader);
            DataResult dataresult = p_335594_.codecOrThrow().parse(p_400265_, o);
            this.visitor.visitComponent(p_335594_, dataresult.getOrThrow(p_339324_ -> {
                this.reader.setCursor(i);
                return ERROR_MALFORMED_COMPONENT.createWithContext((ImmutableStringReader)this.reader, (Object)p_335594_.toString(), p_339324_);
            }));
        }

        private CompletableFuture<Suggestions> suggestStartComponents(SuggestionsBuilder p_335464_) {
            if (p_335464_.getRemaining().isEmpty()) {
                p_335464_.suggest(String.valueOf('['));
            }
            return p_335464_.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestNextOrEndComponents(SuggestionsBuilder p_335894_) {
            if (p_335894_.getRemaining().isEmpty()) {
                p_335894_.suggest(String.valueOf(','));
                p_335894_.suggest(String.valueOf(']'));
            }
            return p_335894_.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestAssignment(SuggestionsBuilder p_335975_) {
            if (p_335975_.getRemaining().isEmpty()) {
                p_335975_.suggest(String.valueOf('='));
            }
            return p_335975_.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder p_336095_) {
            return SharedSuggestionProvider.suggestResource(ItemParser.this.items.listElementIds().map(ResourceKey::location), p_336095_);
        }

        private CompletableFuture<Suggestions> suggestComponentAssignmentOrRemoval(SuggestionsBuilder p_345256_) {
            p_345256_.suggest(String.valueOf('!'));
            return this.suggestComponent(p_345256_, String.valueOf('='));
        }

        private CompletableFuture<Suggestions> suggestComponent(SuggestionsBuilder p_345045_) {
            return this.suggestComponent(p_345045_, "");
        }

        private CompletableFuture<Suggestions> suggestComponent(SuggestionsBuilder p_346056_, String p_346259_) {
            String s = p_346056_.getRemaining().toLowerCase(Locale.ROOT);
            SharedSuggestionProvider.filterResources(BuiltInRegistries.DATA_COMPONENT_TYPE.entrySet(), s, p_336071_ -> ((ResourceKey)p_336071_.getKey()).location(), p_344177_ -> {
                DataComponentType datacomponenttype = (DataComponentType)p_344177_.getValue();
                if (datacomponenttype.codec() != null) {
                    ResourceLocation resourcelocation = ((ResourceKey)p_344177_.getKey()).location();
                    p_346056_.suggest(String.valueOf(resourcelocation) + p_346259_);
                }
            });
            return p_346056_.buildFuture();
        }
    }

    static class SuggestionsVisitor
    implements Visitor {
        private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

        SuggestionsVisitor() {
        }

        @Override
        public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> p_335625_) {
            this.suggestions = p_335625_;
        }

        public CompletableFuture<Suggestions> resolveSuggestions(SuggestionsBuilder p_336050_, StringReader p_335952_) {
            return this.suggestions.apply(p_336050_.createOffset(p_335952_.getCursor()));
        }
    }
}

