/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class LocalCoordinates
implements Coordinates {
    public static final char PREFIX_LOCAL_COORDINATE = '^';
    private final double left;
    private final double up;
    private final double forwards;

    public LocalCoordinates(double p_119902_, double p_119903_, double p_119904_) {
        this.left = p_119902_;
        this.up = p_119903_;
        this.forwards = p_119904_;
    }

    @Override
    public Vec3 getPosition(CommandSourceStack p_119912_) {
        Vec2 vec2 = p_119912_.getRotation();
        Vec3 vec3 = p_119912_.getAnchor().apply(p_119912_);
        float f = Mth.cos((vec2.y + 90.0f) * ((float)Math.PI / 180));
        float f1 = Mth.sin((vec2.y + 90.0f) * ((float)Math.PI / 180));
        float f2 = Mth.cos(-vec2.x * ((float)Math.PI / 180));
        float f3 = Mth.sin(-vec2.x * ((float)Math.PI / 180));
        float f4 = Mth.cos((-vec2.x + 90.0f) * ((float)Math.PI / 180));
        float f5 = Mth.sin((-vec2.x + 90.0f) * ((float)Math.PI / 180));
        Vec3 vec31 = new Vec3(f * f2, f3, f1 * f2);
        Vec3 vec32 = new Vec3(f * f4, f5, f1 * f4);
        Vec3 vec33 = vec31.cross(vec32).scale(-1.0);
        double d0 = vec31.x * this.forwards + vec32.x * this.up + vec33.x * this.left;
        double d1 = vec31.y * this.forwards + vec32.y * this.up + vec33.y * this.left;
        double d2 = vec31.z * this.forwards + vec32.z * this.up + vec33.z * this.left;
        return new Vec3(vec3.x + d0, vec3.y + d1, vec3.z + d2);
    }

    @Override
    public Vec2 getRotation(CommandSourceStack p_119915_) {
        return Vec2.ZERO;
    }

    @Override
    public boolean isXRelative() {
        return true;
    }

    @Override
    public boolean isYRelative() {
        return true;
    }

    @Override
    public boolean isZRelative() {
        return true;
    }

    public static LocalCoordinates parse(StringReader p_119907_) throws CommandSyntaxException {
        int i = p_119907_.getCursor();
        double d0 = LocalCoordinates.readDouble(p_119907_, i);
        if (p_119907_.canRead() && p_119907_.peek() == ' ') {
            p_119907_.skip();
            double d1 = LocalCoordinates.readDouble(p_119907_, i);
            if (p_119907_.canRead() && p_119907_.peek() == ' ') {
                p_119907_.skip();
                double d2 = LocalCoordinates.readDouble(p_119907_, i);
                return new LocalCoordinates(d0, d1, d2);
            }
            p_119907_.setCursor(i);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)p_119907_);
        }
        p_119907_.setCursor(i);
        throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)p_119907_);
    }

    private static double readDouble(StringReader p_119909_, int p_119910_) throws CommandSyntaxException {
        if (!p_119909_.canRead()) {
            throw WorldCoordinate.ERROR_EXPECTED_DOUBLE.createWithContext((ImmutableStringReader)p_119909_);
        }
        if (p_119909_.peek() != '^') {
            p_119909_.setCursor(p_119910_);
            throw Vec3Argument.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)p_119909_);
        }
        p_119909_.skip();
        return p_119909_.canRead() && p_119909_.peek() != ' ' ? p_119909_.readDouble() : 0.0;
    }

    public boolean equals(Object p_119918_) {
        boolean bl;
        if (this == p_119918_) {
            return true;
        }
        if (!(p_119918_ instanceof LocalCoordinates)) {
            bl = false;
        } else {
            LocalCoordinates localcoordinates = (LocalCoordinates)p_119918_;
            bl = this.left == localcoordinates.left && this.up == localcoordinates.up && this.forwards == localcoordinates.forwards;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hash(this.left, this.up, this.forwards);
    }
}

