/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreHolder;

public class ScoreHolderArgument
implements ArgumentType<Result> {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_SCORE_HOLDERS = (p_353117_, p_353118_) -> {
        StringReader stringreader = new StringReader(p_353118_.getInput());
        stringreader.setCursor(p_353118_.getStart());
        EntitySelectorParser entityselectorparser = new EntitySelectorParser(stringreader, EntitySelectorParser.allowSelectors((CommandSourceStack)p_353117_.getSource()));
        try {
            entityselectorparser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return entityselectorparser.fillSuggestions(p_353118_, p_171606_ -> SharedSuggestionProvider.suggest(((CommandSourceStack)p_353117_.getSource()).getOnlinePlayerNames(), p_171606_));
    };
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "*", "@e");
    private static final SimpleCommandExceptionType ERROR_NO_RESULTS = new SimpleCommandExceptionType((Message)Component.translatable("argument.scoreHolder.empty"));
    final boolean multiple;

    public ScoreHolderArgument(boolean p_108216_) {
        this.multiple = p_108216_;
    }

    public static ScoreHolder getName(CommandContext<CommandSourceStack> p_108224_, String p_108225_) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(p_108224_, p_108225_).iterator().next();
    }

    public static Collection<ScoreHolder> getNames(CommandContext<CommandSourceStack> p_108244_, String p_108245_) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(p_108244_, p_108245_, Collections::emptyList);
    }

    public static Collection<ScoreHolder> getNamesWithDefaultWildcard(CommandContext<CommandSourceStack> p_108247_, String p_108248_) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(p_108247_, p_108248_, ((CommandSourceStack)p_108247_.getSource()).getServer().getScoreboard()::getTrackedPlayers);
    }

    public static Collection<ScoreHolder> getNames(CommandContext<CommandSourceStack> p_108227_, String p_108228_, Supplier<Collection<ScoreHolder>> p_108229_) throws CommandSyntaxException {
        Collection<ScoreHolder> collection = ((Result)p_108227_.getArgument(p_108228_, Result.class)).getNames((CommandSourceStack)p_108227_.getSource(), p_108229_);
        if (collection.isEmpty()) {
            throw EntityArgument.NO_ENTITIES_FOUND.create();
        }
        return collection;
    }

    public static ScoreHolderArgument scoreHolder() {
        return new ScoreHolderArgument(false);
    }

    public static ScoreHolderArgument scoreHolders() {
        return new ScoreHolderArgument(true);
    }

    public Result parse(StringReader p_108219_) throws CommandSyntaxException {
        return this.parse(p_108219_, true);
    }

    public <S> Result parse(StringReader p_353125_, S p_353126_) throws CommandSyntaxException {
        return this.parse(p_353125_, EntitySelectorParser.allowSelectors(p_353126_));
    }

    private Result parse(StringReader p_353140_, boolean p_353127_) throws CommandSyntaxException {
        if (p_353140_.canRead() && p_353140_.peek() == '@') {
            EntitySelectorParser entityselectorparser = new EntitySelectorParser(p_353140_, p_353127_);
            EntitySelector entityselector = entityselectorparser.parse();
            if (!this.multiple && entityselector.getMaxResults() > 1) {
                throw EntityArgument.ERROR_NOT_SINGLE_ENTITY.createWithContext((ImmutableStringReader)p_353140_);
            }
            return new SelectorResult(entityselector);
        }
        int i = p_353140_.getCursor();
        while (p_353140_.canRead() && p_353140_.peek() != ' ') {
            p_353140_.skip();
        }
        String s = p_353140_.getString().substring(i, p_353140_.getCursor());
        if (s.equals("*")) {
            return (p_108231_, p_108232_) -> {
                Collection collection = (Collection)p_108232_.get();
                if (collection.isEmpty()) {
                    throw ERROR_NO_RESULTS.create();
                }
                return collection;
            };
        }
        List<ScoreHolder> list = List.of(ScoreHolder.forNameOnly(s));
        if (s.startsWith("#")) {
            return (p_108237_, p_108238_) -> list;
        }
        try {
            UUID uuid = UUID.fromString(s);
            return (p_314703_, p_314704_) -> {
                MinecraftServer minecraftserver = p_314703_.getServer();
                Entity scoreholder = null;
                ArrayList<Entity> list1 = null;
                for (ServerLevel serverlevel : minecraftserver.getAllLevels()) {
                    Entity entity = serverlevel.getEntity(uuid);
                    if (entity == null) continue;
                    if (scoreholder == null) {
                        scoreholder = entity;
                        continue;
                    }
                    if (list1 == null) {
                        list1 = new ArrayList<Entity>();
                        list1.add(scoreholder);
                    }
                    list1.add(entity);
                }
                if (list1 != null) {
                    return list1;
                }
                return scoreholder != null ? List.of(scoreholder) : list;
            };
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return (p_314699_, p_314700_) -> {
                MinecraftServer minecraftserver = p_314699_.getServer();
                ServerPlayer serverplayer = minecraftserver.getPlayerList().getPlayerByName(s);
                return serverplayer != null ? List.of(serverplayer) : list;
            };
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @FunctionalInterface
    public static interface Result {
        public Collection<ScoreHolder> getNames(CommandSourceStack var1, Supplier<Collection<ScoreHolder>> var2) throws CommandSyntaxException;
    }

    public static class SelectorResult
    implements Result {
        private final EntitySelector selector;

        public SelectorResult(EntitySelector p_108256_) {
            this.selector = p_108256_;
        }

        @Override
        public Collection<ScoreHolder> getNames(CommandSourceStack p_108258_, Supplier<Collection<ScoreHolder>> p_108259_) throws CommandSyntaxException {
            List<? extends Entity> list = this.selector.findEntities(p_108258_);
            if (list.isEmpty()) {
                throw EntityArgument.NO_ENTITIES_FOUND.create();
            }
            return List.copyOf(list);
        }
    }

    public static class Info
    implements ArgumentTypeInfo<ScoreHolderArgument, Template> {
        private static final byte FLAG_MULTIPLE = 1;

        @Override
        public void serializeToNetwork(Template p_233469_, FriendlyByteBuf p_233470_) {
            int i = 0;
            if (p_233469_.multiple) {
                i |= 1;
            }
            p_233470_.writeByte(i);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf p_233480_) {
            byte b0 = p_233480_.readByte();
            boolean flag = (b0 & 1) != 0;
            return new Template(flag);
        }

        @Override
        public void serializeToJson(Template p_233466_, JsonObject p_233467_) {
            p_233467_.addProperty("amount", p_233466_.multiple ? "multiple" : "single");
        }

        @Override
        public Template unpack(ScoreHolderArgument p_233472_) {
            return new Template(p_233472_.multiple);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ScoreHolderArgument> {
            final boolean multiple;

            Template(boolean p_233487_) {
                this.multiple = p_233487_;
            }

            @Override
            public ScoreHolderArgument instantiate(CommandBuildContext p_233490_) {
                return new ScoreHolderArgument(this.multiple);
            }

            @Override
            public ArgumentTypeInfo<ScoreHolderArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

