/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ParticleArgument
implements ArgumentType<ParticleOptions> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "particle{foo:bar}");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_PARTICLE = new DynamicCommandExceptionType(p_304093_ -> Component.translatableEscape("particle.notFound", p_304093_));
    public static final DynamicCommandExceptionType ERROR_INVALID_OPTIONS = new DynamicCommandExceptionType(p_340617_ -> Component.translatableEscape("particle.invalidOptions", p_340617_));
    private final HolderLookup.Provider registries;
    private static final TagParser<?> VALUE_PARSER = TagParser.create(NbtOps.INSTANCE);

    public ParticleArgument(CommandBuildContext p_249844_) {
        this.registries = p_249844_;
    }

    public static ParticleArgument particle(CommandBuildContext p_251304_) {
        return new ParticleArgument(p_251304_);
    }

    public static ParticleOptions getParticle(CommandContext<CommandSourceStack> p_103938_, String p_103939_) {
        return (ParticleOptions)p_103938_.getArgument(p_103939_, ParticleOptions.class);
    }

    public ParticleOptions parse(StringReader p_103933_) throws CommandSyntaxException {
        return ParticleArgument.readParticle(p_103933_, this.registries);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static ParticleOptions readParticle(StringReader p_249275_, HolderLookup.Provider p_324619_) throws CommandSyntaxException {
        ParticleType<?> particletype = ParticleArgument.readParticleType(p_249275_, p_324619_.lookupOrThrow(Registries.PARTICLE_TYPE));
        return ParticleArgument.readParticle(VALUE_PARSER, p_249275_, particletype, p_324619_);
    }

    private static ParticleType<?> readParticleType(StringReader p_249621_, HolderLookup<ParticleType<?>> p_248983_) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocation.read(p_249621_);
        ResourceKey<ParticleType<?>> resourcekey = ResourceKey.create(Registries.PARTICLE_TYPE, resourcelocation);
        return p_248983_.get(resourcekey).orElseThrow(() -> ERROR_UNKNOWN_PARTICLE.createWithContext((ImmutableStringReader)p_249621_, (Object)resourcelocation)).value();
    }

    private static <T extends ParticleOptions, O> T readParticle(TagParser<O> p_409667_, StringReader p_103935_, ParticleType<T> p_103936_, HolderLookup.Provider p_323668_) throws CommandSyntaxException {
        RegistryOps<O> registryops = p_323668_.createSerializationContext(p_409667_.getOps());
        Object o = p_103935_.canRead() && p_103935_.peek() == '{' ? p_409667_.parseAsArgument(p_103935_) : registryops.emptyMap();
        return (T)((ParticleOptions)p_103936_.codec().codec().parse(registryops, o).getOrThrow(arg_0 -> ((DynamicCommandExceptionType)ERROR_INVALID_OPTIONS).create(arg_0)));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_103948_, SuggestionsBuilder p_103949_) {
        HolderGetter registrylookup = this.registries.lookupOrThrow(Registries.PARTICLE_TYPE);
        return SharedSuggestionProvider.suggestResource(registrylookup.listElementIds().map(ResourceKey::location), p_103949_);
    }
}

