/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class AngleArgument
implements ArgumentType<SingleAngle> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0", "~", "~-5");
    public static final SimpleCommandExceptionType ERROR_NOT_COMPLETE = new SimpleCommandExceptionType((Message)Component.translatable("argument.angle.incomplete"));
    public static final SimpleCommandExceptionType ERROR_INVALID_ANGLE = new SimpleCommandExceptionType((Message)Component.translatable("argument.angle.invalid"));

    public static AngleArgument angle() {
        return new AngleArgument();
    }

    public static float getAngle(CommandContext<CommandSourceStack> p_83811_, String p_83812_) {
        return ((SingleAngle)p_83811_.getArgument(p_83812_, SingleAngle.class)).getAngle((CommandSourceStack)p_83811_.getSource());
    }

    public SingleAngle parse(StringReader p_83809_) throws CommandSyntaxException {
        float f;
        if (!p_83809_.canRead()) {
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)p_83809_);
        }
        boolean flag = WorldCoordinate.isRelative(p_83809_);
        float f2 = f = p_83809_.canRead() && p_83809_.peek() != ' ' ? p_83809_.readFloat() : 0.0f;
        if (!Float.isNaN(f) && !Float.isInfinite(f)) {
            return new SingleAngle(f, flag);
        }
        throw ERROR_INVALID_ANGLE.createWithContext((ImmutableStringReader)p_83809_);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static final class SingleAngle {
        private final float angle;
        private final boolean isRelative;

        SingleAngle(float p_83819_, boolean p_83820_) {
            this.angle = p_83819_;
            this.isRelative = p_83820_;
        }

        public float getAngle(CommandSourceStack p_83826_) {
            return Mth.wrapDegrees(this.isRelative ? this.angle + p_83826_.getRotation().y : this.angle);
        }
    }
}

