/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.searchtree;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.searchtree.SuffixArray;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface ResourceLocationSearchTree<T> {
    public static <T> ResourceLocationSearchTree<T> empty() {
        return new ResourceLocationSearchTree<T>(){

            @Override
            public List<T> searchNamespace(String p_235218_) {
                return List.of();
            }

            @Override
            public List<T> searchPath(String p_235220_) {
                return List.of();
            }
        };
    }

    public static <T> ResourceLocationSearchTree<T> create(List<T> p_235213_, Function<T, Stream<ResourceLocation>> p_235214_) {
        if (p_235213_.isEmpty()) {
            return ResourceLocationSearchTree.empty();
        }
        final SuffixArray suffixarray = new SuffixArray();
        final SuffixArray suffixarray1 = new SuffixArray();
        for (Object t : p_235213_) {
            p_235214_.apply(t).forEach(p_235210_ -> {
                suffixarray.add(t, p_235210_.getNamespace().toLowerCase(Locale.ROOT));
                suffixarray1.add(t, p_235210_.getPath().toLowerCase(Locale.ROOT));
            });
        }
        suffixarray.generate();
        suffixarray1.generate();
        return new ResourceLocationSearchTree<T>(){

            @Override
            public List<T> searchNamespace(String p_235227_) {
                return suffixarray.search(p_235227_);
            }

            @Override
            public List<T> searchPath(String p_235229_) {
                return suffixarray1.search(p_235229_);
            }
        };
    }

    public List<T> searchNamespace(String var1);

    public List<T> searchPath(String var1);
}

