/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.sounds;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MinecartSoundInstance
extends AbstractTickableSoundInstance {
    private static final float VOLUME_MIN = 0.0f;
    private static final float VOLUME_MAX = 0.7f;
    private static final float PITCH_MIN = 0.0f;
    private static final float PITCH_MAX = 1.0f;
    private static final float PITCH_DELTA = 0.0025f;
    private final AbstractMinecart minecart;
    private float pitch = 0.0f;

    public MinecartSoundInstance(AbstractMinecart p_119696_) {
        super(SoundEvents.MINECART_RIDING, SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.minecart = p_119696_;
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
        this.x = (float)p_119696_.getX();
        this.y = (float)p_119696_.getY();
        this.z = (float)p_119696_.getZ();
    }

    @Override
    public boolean canPlaySound() {
        return !this.minecart.isSilent();
    }

    @Override
    public boolean canStartSilent() {
        return true;
    }

    @Override
    public void tick() {
        if (this.minecart.isRemoved()) {
            this.stop();
        } else {
            boolean flag;
            this.x = (float)this.minecart.getX();
            this.y = (float)this.minecart.getY();
            this.z = (float)this.minecart.getZ();
            float f = (float)this.minecart.getDeltaMovement().horizontalDistance();
            boolean bl = flag = !this.minecart.isOnRails() && this.minecart.getBehavior() instanceof NewMinecartBehavior;
            if (f >= 0.01f && this.minecart.level().tickRateManager().runsNormally() && !flag) {
                this.pitch = Mth.clamp(this.pitch + 0.0025f, 0.0f, 1.0f);
                this.volume = Mth.lerp(Mth.clamp(f, 0.0f, 0.5f), 0.0f, 0.7f);
            } else {
                this.pitch = 0.0f;
                this.volume = 0.0f;
            }
        }
    }
}

