/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.server;

import com.google.common.hash.HashCode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.server.PackDownloader;
import net.minecraft.client.resources.server.PackLoadFeedback;
import net.minecraft.client.resources.server.PackReloadConfig;
import net.minecraft.server.packs.DownloadQueue;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ServerPackManager {
    private final PackDownloader downloader;
    final PackLoadFeedback packLoadFeedback;
    private final PackReloadConfig reloadConfig;
    private final Runnable updateRequest;
    private PackPromptStatus packPromptStatus;
    final List<ServerPackData> packs = new ArrayList<ServerPackData>();

    public ServerPackManager(PackDownloader p_314651_, PackLoadFeedback p_314441_, PackReloadConfig p_314471_, Runnable p_314453_, PackPromptStatus p_314476_) {
        this.downloader = p_314651_;
        this.packLoadFeedback = p_314441_;
        this.reloadConfig = p_314471_;
        this.updateRequest = p_314453_;
        this.packPromptStatus = p_314476_;
    }

    void registerForUpdate() {
        this.updateRequest.run();
    }

    private void markExistingPacksAsRemoved(UUID p_314529_) {
        for (ServerPackData serverpackmanager$serverpackdata : this.packs) {
            if (!serverpackmanager$serverpackdata.id.equals(p_314529_)) continue;
            serverpackmanager$serverpackdata.setRemovalReasonIfNotSet(RemovalReason.SERVER_REPLACED);
        }
    }

    public void pushPack(UUID p_314641_, URL p_314493_, @Nullable HashCode p_314571_) {
        if (this.packPromptStatus == PackPromptStatus.DECLINED) {
            this.packLoadFeedback.reportFinalResult(p_314641_, PackLoadFeedback.FinalResult.DECLINED);
        } else {
            this.pushNewPack(p_314641_, new ServerPackData(p_314641_, p_314493_, p_314571_));
        }
    }

    public void pushLocalPack(UUID p_314448_, Path p_314520_) {
        if (this.packPromptStatus == PackPromptStatus.DECLINED) {
            this.packLoadFeedback.reportFinalResult(p_314448_, PackLoadFeedback.FinalResult.DECLINED);
        } else {
            URL url;
            try {
                url = p_314520_.toUri().toURL();
            }
            catch (MalformedURLException malformedurlexception) {
                throw new IllegalStateException("Can't convert path to URL " + String.valueOf(p_314520_), malformedurlexception);
            }
            ServerPackData serverpackmanager$serverpackdata = new ServerPackData(p_314448_, url, null);
            serverpackmanager$serverpackdata.downloadStatus = PackDownloadStatus.DONE;
            serverpackmanager$serverpackdata.path = p_314520_;
            this.pushNewPack(p_314448_, serverpackmanager$serverpackdata);
        }
    }

    private void pushNewPack(UUID p_314541_, ServerPackData p_314473_) {
        this.markExistingPacksAsRemoved(p_314541_);
        this.packs.add(p_314473_);
        if (this.packPromptStatus == PackPromptStatus.ALLOWED) {
            this.acceptPack(p_314473_);
        }
        this.registerForUpdate();
    }

    private void acceptPack(ServerPackData p_314599_) {
        this.packLoadFeedback.reportUpdate(p_314599_.id, PackLoadFeedback.Update.ACCEPTED);
        p_314599_.promptAccepted = true;
    }

    @Nullable
    private ServerPackData findPackInfo(UUID p_314517_) {
        for (ServerPackData serverpackmanager$serverpackdata : this.packs) {
            if (serverpackmanager$serverpackdata.isRemoved() || !serverpackmanager$serverpackdata.id.equals(p_314517_)) continue;
            return serverpackmanager$serverpackdata;
        }
        return null;
    }

    public void popPack(UUID p_314547_) {
        ServerPackData serverpackmanager$serverpackdata = this.findPackInfo(p_314547_);
        if (serverpackmanager$serverpackdata != null) {
            serverpackmanager$serverpackdata.setRemovalReasonIfNotSet(RemovalReason.SERVER_REMOVED);
            this.registerForUpdate();
        }
    }

    public void popAll() {
        for (ServerPackData serverpackmanager$serverpackdata : this.packs) {
            serverpackmanager$serverpackdata.setRemovalReasonIfNotSet(RemovalReason.SERVER_REMOVED);
        }
        this.registerForUpdate();
    }

    public void allowServerPacks() {
        this.packPromptStatus = PackPromptStatus.ALLOWED;
        for (ServerPackData serverpackmanager$serverpackdata : this.packs) {
            if (serverpackmanager$serverpackdata.promptAccepted || serverpackmanager$serverpackdata.isRemoved()) continue;
            this.acceptPack(serverpackmanager$serverpackdata);
        }
        this.registerForUpdate();
    }

    public void rejectServerPacks() {
        this.packPromptStatus = PackPromptStatus.DECLINED;
        for (ServerPackData serverpackmanager$serverpackdata : this.packs) {
            if (serverpackmanager$serverpackdata.promptAccepted) continue;
            serverpackmanager$serverpackdata.setRemovalReasonIfNotSet(RemovalReason.DECLINED);
        }
        this.registerForUpdate();
    }

    public void resetPromptStatus() {
        this.packPromptStatus = PackPromptStatus.PENDING;
    }

    public void tick() {
        boolean flag = this.updateDownloads();
        if (!flag) {
            this.triggerReloadIfNeeded();
        }
        this.cleanupRemovedPacks();
    }

    private void cleanupRemovedPacks() {
        this.packs.removeIf(p_314901_ -> {
            if (p_314901_.activationStatus != ActivationStatus.INACTIVE) {
                return false;
            }
            if (p_314901_.removalReason != null) {
                PackLoadFeedback.FinalResult packloadfeedback$finalresult = p_314901_.removalReason.serverResponse;
                if (packloadfeedback$finalresult != null) {
                    this.packLoadFeedback.reportFinalResult(p_314901_.id, packloadfeedback$finalresult);
                }
                return true;
            }
            return false;
        });
    }

    private void onDownload(Collection<ServerPackData> p_314562_, DownloadQueue.BatchResult p_314549_) {
        if (!p_314549_.failed().isEmpty()) {
            for (ServerPackData serverpackmanager$serverpackdata : this.packs) {
                if (serverpackmanager$serverpackdata.activationStatus == ActivationStatus.ACTIVE) continue;
                if (p_314549_.failed().contains(serverpackmanager$serverpackdata.id)) {
                    serverpackmanager$serverpackdata.setRemovalReasonIfNotSet(RemovalReason.DOWNLOAD_FAILED);
                    continue;
                }
                serverpackmanager$serverpackdata.setRemovalReasonIfNotSet(RemovalReason.DISCARDED);
            }
        }
        for (ServerPackData serverpackmanager$serverpackdata1 : p_314562_) {
            Path path = p_314549_.downloaded().get(serverpackmanager$serverpackdata1.id);
            if (path == null) continue;
            serverpackmanager$serverpackdata1.downloadStatus = PackDownloadStatus.DONE;
            serverpackmanager$serverpackdata1.path = path;
            if (serverpackmanager$serverpackdata1.isRemoved()) continue;
            this.packLoadFeedback.reportUpdate(serverpackmanager$serverpackdata1.id, PackLoadFeedback.Update.DOWNLOADED);
        }
        this.registerForUpdate();
    }

    private boolean updateDownloads() {
        ArrayList<ServerPackData> list = new ArrayList<ServerPackData>();
        boolean flag = false;
        for (ServerPackData serverpackmanager$serverpackdata : this.packs) {
            if (serverpackmanager$serverpackdata.isRemoved() || !serverpackmanager$serverpackdata.promptAccepted) continue;
            if (serverpackmanager$serverpackdata.downloadStatus != PackDownloadStatus.DONE) {
                flag = true;
            }
            if (serverpackmanager$serverpackdata.downloadStatus != PackDownloadStatus.REQUESTED) continue;
            serverpackmanager$serverpackdata.downloadStatus = PackDownloadStatus.PENDING;
            list.add(serverpackmanager$serverpackdata);
        }
        if (!list.isEmpty()) {
            HashMap<UUID, DownloadQueue.DownloadRequest> map = new HashMap<UUID, DownloadQueue.DownloadRequest>();
            for (ServerPackData serverpackmanager$serverpackdata1 : list) {
                map.put(serverpackmanager$serverpackdata1.id, new DownloadQueue.DownloadRequest(serverpackmanager$serverpackdata1.url, serverpackmanager$serverpackdata1.hash));
            }
            this.downloader.download(map, p_314466_ -> this.onDownload((Collection<ServerPackData>)list, (DownloadQueue.BatchResult)p_314466_));
        }
        return flag;
    }

    private void triggerReloadIfNeeded() {
        boolean flag = false;
        final ArrayList<ServerPackData> list = new ArrayList<ServerPackData>();
        final ArrayList<ServerPackData> list1 = new ArrayList<ServerPackData>();
        for (ServerPackData serverpackmanager$serverpackdata : this.packs) {
            boolean flag1;
            if (serverpackmanager$serverpackdata.activationStatus == ActivationStatus.PENDING) {
                return;
            }
            boolean bl = flag1 = serverpackmanager$serverpackdata.promptAccepted && serverpackmanager$serverpackdata.downloadStatus == PackDownloadStatus.DONE && !serverpackmanager$serverpackdata.isRemoved();
            if (flag1 && serverpackmanager$serverpackdata.activationStatus == ActivationStatus.INACTIVE) {
                list.add(serverpackmanager$serverpackdata);
                flag = true;
            }
            if (serverpackmanager$serverpackdata.activationStatus != ActivationStatus.ACTIVE) continue;
            if (!flag1) {
                flag = true;
                list1.add(serverpackmanager$serverpackdata);
                continue;
            }
            list.add(serverpackmanager$serverpackdata);
        }
        if (flag) {
            for (ServerPackData serverpackmanager$serverpackdata1 : list) {
                if (serverpackmanager$serverpackdata1.activationStatus == ActivationStatus.ACTIVE) continue;
                serverpackmanager$serverpackdata1.activationStatus = ActivationStatus.PENDING;
            }
            for (ServerPackData serverpackmanager$serverpackdata2 : list1) {
                serverpackmanager$serverpackdata2.activationStatus = ActivationStatus.PENDING;
            }
            this.reloadConfig.scheduleReload(new PackReloadConfig.Callbacks(){

                @Override
                public void onSuccess() {
                    for (ServerPackData serverpackmanager$serverpackdata3 : list) {
                        serverpackmanager$serverpackdata3.activationStatus = ActivationStatus.ACTIVE;
                        if (serverpackmanager$serverpackdata3.removalReason != null) continue;
                        ServerPackManager.this.packLoadFeedback.reportFinalResult(serverpackmanager$serverpackdata3.id, PackLoadFeedback.FinalResult.APPLIED);
                    }
                    for (ServerPackData serverpackmanager$serverpackdata4 : list1) {
                        serverpackmanager$serverpackdata4.activationStatus = ActivationStatus.INACTIVE;
                    }
                    ServerPackManager.this.registerForUpdate();
                }

                @Override
                public void onFailure(boolean p_314558_) {
                    if (!p_314558_) {
                        list.clear();
                        for (ServerPackData serverpackmanager$serverpackdata3 : ServerPackManager.this.packs) {
                            switch (serverpackmanager$serverpackdata3.activationStatus.ordinal()) {
                                case 0: {
                                    serverpackmanager$serverpackdata3.setRemovalReasonIfNotSet(RemovalReason.DISCARDED);
                                    break;
                                }
                                case 1: {
                                    serverpackmanager$serverpackdata3.activationStatus = ActivationStatus.INACTIVE;
                                    serverpackmanager$serverpackdata3.setRemovalReasonIfNotSet(RemovalReason.ACTIVATION_FAILED);
                                    break;
                                }
                                case 2: {
                                    list.add(serverpackmanager$serverpackdata3);
                                }
                            }
                        }
                        ServerPackManager.this.registerForUpdate();
                    } else {
                        for (ServerPackData serverpackmanager$serverpackdata4 : ServerPackManager.this.packs) {
                            if (serverpackmanager$serverpackdata4.activationStatus != ActivationStatus.PENDING) continue;
                            serverpackmanager$serverpackdata4.activationStatus = ActivationStatus.INACTIVE;
                        }
                    }
                }

                @Override
                public List<PackReloadConfig.IdAndPath> packsToLoad() {
                    return list.stream().map(p_314577_ -> new PackReloadConfig.IdAndPath(p_314577_.id, p_314577_.path)).toList();
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum PackPromptStatus {
        PENDING,
        ALLOWED,
        DECLINED;

    }

    @OnlyIn(value=Dist.CLIENT)
    static class ServerPackData {
        final UUID id;
        final URL url;
        @Nullable
        final HashCode hash;
        @Nullable
        Path path;
        @Nullable
        RemovalReason removalReason;
        PackDownloadStatus downloadStatus = PackDownloadStatus.REQUESTED;
        ActivationStatus activationStatus = ActivationStatus.INACTIVE;
        boolean promptAccepted;

        ServerPackData(UUID p_314450_, URL p_314542_, @Nullable HashCode p_314445_) {
            this.id = p_314450_;
            this.url = p_314542_;
            this.hash = p_314445_;
        }

        public void setRemovalReasonIfNotSet(RemovalReason p_314504_) {
            if (this.removalReason == null) {
                this.removalReason = p_314504_;
            }
        }

        public boolean isRemoved() {
            return this.removalReason != null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum RemovalReason {
        DOWNLOAD_FAILED(PackLoadFeedback.FinalResult.DOWNLOAD_FAILED),
        ACTIVATION_FAILED(PackLoadFeedback.FinalResult.ACTIVATION_FAILED),
        DECLINED(PackLoadFeedback.FinalResult.DECLINED),
        DISCARDED(PackLoadFeedback.FinalResult.DISCARDED),
        SERVER_REMOVED(null),
        SERVER_REPLACED(null);

        @Nullable
        final PackLoadFeedback.FinalResult serverResponse;

        private RemovalReason(PackLoadFeedback.FinalResult p_314987_) {
            this.serverResponse = p_314987_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum PackDownloadStatus {
        REQUESTED,
        PENDING,
        DONE;

    }

    @OnlyIn(value=Dist.CLIENT)
    static enum ActivationStatus {
        INACTIVE,
        PENDING,
        ACTIVE;

    }
}

