/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;
import net.neoforged.fml.common.asm.enumextension.NamedEnum;

@OnlyIn(value=Dist.CLIENT)
public record EquipmentClientInfo(Map<LayerType, List<Layer>> layers) {
    private static final Codec<List<Layer>> LAYER_LIST_CODEC = ExtraCodecs.nonEmptyList(Layer.CODEC.listOf());
    public static final Codec<EquipmentClientInfo> CODEC = RecordCodecBuilder.create(p_388468_ -> p_388468_.group((App)ExtraCodecs.nonEmptyMap(Codec.unboundedMap(LayerType.CODEC, LAYER_LIST_CODEC)).fieldOf("layers").forGetter(EquipmentClientInfo::layers)).apply((Applicative)p_388468_, EquipmentClientInfo::new));

    public static Builder builder() {
        return new Builder();
    }

    public List<Layer> getLayers(LayerType p_387923_) {
        return this.layers.getOrDefault(p_387923_, List.of());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Map<LayerType, List<Layer>> layersByType = new EnumMap<LayerType, List<Layer>>(LayerType.class);

        Builder() {
        }

        public Builder addHumanoidLayers(ResourceLocation p_388946_) {
            return this.addHumanoidLayers(p_388946_, false);
        }

        public Builder addHumanoidLayers(ResourceLocation p_387097_, boolean p_387092_) {
            this.addLayers(LayerType.HUMANOID_LEGGINGS, Layer.leatherDyeable(p_387097_, p_387092_));
            this.addMainHumanoidLayer(p_387097_, p_387092_);
            return this;
        }

        public Builder addMainHumanoidLayer(ResourceLocation p_387549_, boolean p_388218_) {
            return this.addLayers(LayerType.HUMANOID, Layer.leatherDyeable(p_387549_, p_388218_));
        }

        public Builder addLayers(LayerType p_388688_, Layer ... p_388509_) {
            Collections.addAll(this.layersByType.computeIfAbsent(p_388688_, p_387338_ -> new ArrayList()), p_388509_);
            return this;
        }

        public EquipmentClientInfo build() {
            return new EquipmentClientInfo((Map)this.layersByType.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_386826_ -> List.copyOf((Collection)p_386826_.getValue()))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @NamedEnum
    public static enum LayerType implements StringRepresentable,
    IExtensibleEnum
    {
        HUMANOID("humanoid"),
        HUMANOID_LEGGINGS("humanoid_leggings"),
        WINGS("wings"),
        WOLF_BODY("wolf_body"),
        HORSE_BODY("horse_body"),
        LLAMA_BODY("llama_body"),
        PIG_SADDLE("pig_saddle"),
        STRIDER_SADDLE("strider_saddle"),
        CAMEL_SADDLE("camel_saddle"),
        HORSE_SADDLE("horse_saddle"),
        DONKEY_SADDLE("donkey_saddle"),
        MULE_SADDLE("mule_saddle"),
        ZOMBIE_HORSE_SADDLE("zombie_horse_saddle"),
        SKELETON_HORSE_SADDLE("skeleton_horse_saddle"),
        HAPPY_GHAST_BODY("happy_ghast_body");

        public static final Codec<LayerType> CODEC;
        private final String id;

        private LayerType(String p_387059_) {
            this.id = p_387059_.replaceAll(":", "/");
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        public String trimAssetPrefix() {
            return "trims/entity/" + this.id;
        }

        public static ExtensionInfo getExtensionInfo() {
            return ExtensionInfo.nonExtended(LayerType.class);
        }

        static {
            CODEC = StringRepresentable.fromEnum(LayerType::values);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Layer(ResourceLocation textureId, Optional<Dyeable> dyeable, boolean usePlayerTexture) {
        public static final Codec<Layer> CODEC = RecordCodecBuilder.create(p_388785_ -> p_388785_.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Layer::textureId), (App)Dyeable.CODEC.optionalFieldOf("dyeable").forGetter(Layer::dyeable), (App)Codec.BOOL.optionalFieldOf("use_player_texture", (Object)false).forGetter(Layer::usePlayerTexture)).apply((Applicative)p_388785_, Layer::new));

        public Layer(ResourceLocation p_386866_) {
            this(p_386866_, Optional.empty(), false);
        }

        public static Layer leatherDyeable(ResourceLocation p_388888_, boolean p_388540_) {
            return new Layer(p_388888_, p_388540_ ? Optional.of(new Dyeable(Optional.of(-6265536))) : Optional.empty(), false);
        }

        public static Layer onlyIfDyed(ResourceLocation p_388030_, boolean p_386457_) {
            return new Layer(p_388030_, p_386457_ ? Optional.of(new Dyeable(Optional.empty())) : Optional.empty(), false);
        }

        public ResourceLocation getTextureLocation(LayerType p_386578_) {
            return this.textureId.withPath(p_386699_ -> "textures/entity/equipment/" + p_386578_.getSerializedName() + "/" + p_386699_ + ".png");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Dyeable(Optional<Integer> colorWhenUndyed) {
        public static final Codec<Dyeable> CODEC = RecordCodecBuilder.create(p_387846_ -> p_387846_.group((App)ExtraCodecs.RGB_COLOR_CODEC.optionalFieldOf("color_when_undyed").forGetter(Dyeable::colorWhenUndyed)).apply((Applicative)p_387846_, Dyeable::new));
    }
}

