/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientRegistryLayer;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.PlaceholderLookupProvider;
import net.minecraft.util.StrictJsonParser;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientItemInfoLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter LISTER = FileToIdConverter.json("items");

    public static CompletableFuture<LoadedClientInfos> scheduleLoad(ResourceManager p_390398_, Executor p_390441_) {
        RegistryAccess.Frozen registryaccess$frozen = ClientRegistryLayer.createRegistryAccess().compositeAccess();
        return CompletableFuture.supplyAsync(() -> LISTER.listMatchingResources(p_390398_), p_390441_).thenCompose(p_399357_ -> {
            ArrayList list = new ArrayList(p_399357_.size());
            p_399357_.forEach((p_399361_, p_399362_) -> list.add(CompletableFuture.supplyAsync(() -> {
                ResourceLocation resourcelocation = LISTER.fileToId((ResourceLocation)p_399361_);
                try {
                    PendingLoad clientiteminfoloader$pendingload;
                    try (BufferedReader reader = p_399362_.openAsReader();){
                        PlaceholderLookupProvider placeholderlookupprovider = new PlaceholderLookupProvider(registryaccess$frozen);
                        RegistryOps dynamicops = placeholderlookupprovider.createSerializationContext(JsonOps.INSTANCE);
                        ClientItem clientitem = ClientItem.CODEC.parse(dynamicops, (Object)StrictJsonParser.parse(reader)).ifError(p_390349_ -> LOGGER.error("Couldn't parse item model '{}' from pack '{}': {}", new Object[]{resourcelocation, p_399362_.sourcePackId(), p_390349_.message()})).result().map(p_399364_ -> placeholderlookupprovider.hasRegisteredPlaceholders() ? p_399364_.withRegistrySwapper(placeholderlookupprovider.createSwapper()) : p_399364_).orElse(null);
                        clientiteminfoloader$pendingload = new PendingLoad(resourcelocation, clientitem);
                    }
                    return clientiteminfoloader$pendingload;
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to open item model {} from pack '{}'", new Object[]{p_399361_, p_399362_.sourcePackId(), exception});
                    return new PendingLoad(resourcelocation, null);
                }
            }, p_390441_)));
            return Util.sequence(list).thenApply(p_390406_ -> {
                HashMap<ResourceLocation, ClientItem> map = new HashMap<ResourceLocation, ClientItem>();
                for (PendingLoad clientiteminfoloader$pendingload : p_390406_) {
                    if (clientiteminfoloader$pendingload.clientItemInfo == null) continue;
                    map.put(clientiteminfoloader$pendingload.id, clientiteminfoloader$pendingload.clientItemInfo);
                }
                return new LoadedClientInfos(map);
            });
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    record PendingLoad(ResourceLocation id, @Nullable ClientItem clientItemInfo) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public record LoadedClientInfos(Map<ResourceLocation, ClientItem> contents) {
    }
}

