/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.resources.model.BlockStateDefinitions;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BlockStateModelLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter BLOCKSTATE_LISTER = FileToIdConverter.json("blockstates");

    public static CompletableFuture<LoadedModels> loadBlockStates(ResourceManager p_387674_, Executor p_388736_) {
        Function<ResourceLocation, StateDefinition<Block, BlockState>> function = BlockStateDefinitions.definitionLocationToBlockStateMapper();
        return CompletableFuture.supplyAsync(() -> BLOCKSTATE_LISTER.listMatchingResourceStacks(p_387674_), p_388736_).thenCompose(p_404112_ -> {
            ArrayList<CompletableFuture<LoadedModels>> list = new ArrayList<CompletableFuture<LoadedModels>>(p_404112_.size());
            for (Map.Entry entry : p_404112_.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    ResourceLocation resourcelocation = BLOCKSTATE_LISTER.fileToId((ResourceLocation)entry.getKey());
                    StateDefinition statedefinition = (StateDefinition)function.apply(resourcelocation);
                    if (statedefinition == null) {
                        LOGGER.debug("Discovered unknown block state definition {}, ignoring", (Object)resourcelocation);
                        return null;
                    }
                    List list1 = (List)entry.getValue();
                    ArrayList<LoadedBlockModelDefinition> list2 = new ArrayList<LoadedBlockModelDefinition>(list1.size());
                    for (Resource resource : list1) {
                        try {
                            BufferedReader reader = resource.openAsReader();
                            try {
                                JsonElement jsonelement = StrictJsonParser.parse(reader);
                                BlockModelDefinition blockmodeldefinition = (BlockModelDefinition)BlockModelDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement).getOrThrow(JsonParseException::new);
                                list2.add(new LoadedBlockModelDefinition(resource.sourcePackId(), blockmodeldefinition));
                            }
                            finally {
                                if (reader == null) continue;
                                ((Reader)reader).close();
                            }
                        }
                        catch (Exception exception1) {
                            LOGGER.error("Failed to load blockstate definition {} from pack {}", new Object[]{resourcelocation, resource.sourcePackId(), exception1});
                        }
                    }
                    try {
                        return BlockStateModelLoader.loadBlockStateDefinitionStack(resourcelocation, statedefinition, list2);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to load blockstate definition {}", (Object)resourcelocation, (Object)exception);
                        return null;
                    }
                }, p_388736_));
            }
            return Util.sequence(list).thenApply(p_404105_ -> {
                IdentityHashMap<BlockState, BlockStateModel.UnbakedRoot> map = new IdentityHashMap<BlockState, BlockStateModel.UnbakedRoot>();
                for (LoadedModels blockstatemodelloader$loadedmodels : p_404105_) {
                    if (blockstatemodelloader$loadedmodels == null) continue;
                    map.putAll(blockstatemodelloader$loadedmodels.models());
                }
                return new LoadedModels(map);
            });
        });
    }

    private static LoadedModels loadBlockStateDefinitionStack(ResourceLocation p_362931_, StateDefinition<Block, BlockState> p_363315_, List<LoadedBlockModelDefinition> p_360590_) {
        IdentityHashMap<BlockState, BlockStateModel.UnbakedRoot> map = new IdentityHashMap<BlockState, BlockStateModel.UnbakedRoot>();
        for (LoadedBlockModelDefinition blockstatemodelloader$loadedblockmodeldefinition : p_360590_) {
            map.putAll(blockstatemodelloader$loadedblockmodeldefinition.contents.instantiate(p_363315_, () -> String.valueOf(p_362931_) + "/" + blockstatemodelloader$loadedblockmodeldefinition.source));
        }
        return new LoadedModels(map);
    }

    @OnlyIn(value=Dist.CLIENT)
    record LoadedBlockModelDefinition(String source, BlockModelDefinition contents) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public record LoadedModels(Map<BlockState, BlockStateModel.UnbakedRoot> models) {
    }
}

