/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.metadata.animation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public record AnimationMetadataSection(Optional<List<AnimationFrame>> frames, Optional<Integer> frameWidth, Optional<Integer> frameHeight, int defaultFrameTime, boolean interpolatedFrames) {
    public static final Codec<AnimationMetadataSection> CODEC = RecordCodecBuilder.create(p_389697_ -> p_389697_.group((App)AnimationFrame.CODEC.listOf().optionalFieldOf("frames").forGetter(AnimationMetadataSection::frames), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("width").forGetter(AnimationMetadataSection::frameWidth), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("height").forGetter(AnimationMetadataSection::frameHeight), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("frametime", (Object)1).forGetter(AnimationMetadataSection::defaultFrameTime), (App)Codec.BOOL.optionalFieldOf("interpolate", (Object)false).forGetter(AnimationMetadataSection::interpolatedFrames)).apply((Applicative)p_389697_, AnimationMetadataSection::new));
    public static final MetadataSectionType<AnimationMetadataSection> TYPE = new MetadataSectionType<AnimationMetadataSection>("animation", CODEC);

    public FrameSize calculateFrameSize(int p_249859_, int p_250148_) {
        if (this.frameWidth.isPresent()) {
            return this.frameHeight.isPresent() ? new FrameSize(this.frameWidth.get(), this.frameHeight.get()) : new FrameSize(this.frameWidth.get(), p_250148_);
        }
        if (this.frameHeight.isPresent()) {
            return new FrameSize(p_249859_, this.frameHeight.get());
        }
        int i = Math.min(p_249859_, p_250148_);
        return new FrameSize(i, i);
    }
}

