/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.SignatureState;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.SkinTextureDownloader;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class SkinManager {
    static final Logger LOGGER = LogUtils.getLogger();
    private final MinecraftSessionService sessionService;
    private final LoadingCache<CacheKey, CompletableFuture<Optional<PlayerSkin>>> skinCache;
    private final TextureCache skinTextures;
    private final TextureCache capeTextures;
    private final TextureCache elytraTextures;

    public SkinManager(Path p_294690_, final MinecraftSessionService p_118814_, final Executor p_294105_) {
        this.sessionService = p_118814_;
        this.skinTextures = new TextureCache(p_294690_, MinecraftProfileTexture.Type.SKIN);
        this.capeTextures = new TextureCache(p_294690_, MinecraftProfileTexture.Type.CAPE);
        this.elytraTextures = new TextureCache(p_294690_, MinecraftProfileTexture.Type.ELYTRA);
        this.skinCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(15L)).build((CacheLoader)new CacheLoader<CacheKey, CompletableFuture<Optional<PlayerSkin>>>(){

            public CompletableFuture<Optional<PlayerSkin>> load(CacheKey p_296373_) {
                return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    Property property = p_296373_.packedTextures();
                    if (property == null) {
                        return MinecraftProfileTextures.EMPTY;
                    }
                    MinecraftProfileTextures minecraftprofiletextures = p_118814_.unpackTextures(property);
                    if (minecraftprofiletextures.signatureState() == SignatureState.INVALID) {
                        LOGGER.warn("Profile contained invalid signature for textures property (profile id: {})", (Object)p_296373_.profileId());
                    }
                    return minecraftprofiletextures;
                }, Util.backgroundExecutor().forName("unpackSkinTextures")).thenComposeAsync(p_307130_ -> SkinManager.this.registerTextures(p_296373_.profileId(), (MinecraftProfileTextures)p_307130_), p_294105_)).handle((p_389367_, p_389368_) -> {
                    if (p_389368_ != null) {
                        LOGGER.warn("Failed to load texture for profile {}", (Object)p_296373_.profileId, p_389368_);
                    }
                    return Optional.ofNullable(p_389367_);
                });
            }
        });
    }

    public Supplier<PlayerSkin> lookupInsecure(GameProfile p_295432_) {
        CompletableFuture<Optional<PlayerSkin>> completablefuture = this.getOrLoad(p_295432_);
        PlayerSkin playerskin = DefaultPlayerSkin.get(p_295432_);
        return () -> completablefuture.getNow(Optional.empty()).orElse(playerskin);
    }

    public PlayerSkin getInsecureSkin(GameProfile p_294261_) {
        PlayerSkin playerskin = this.getInsecureSkin(p_294261_, null);
        return playerskin != null ? playerskin : DefaultPlayerSkin.get(p_294261_);
    }

    @Nullable
    public PlayerSkin getInsecureSkin(GameProfile p_428295_, @Nullable PlayerSkin p_428291_) {
        return this.getOrLoad(p_428295_).getNow(Optional.empty()).orElse(p_428291_);
    }

    public CompletableFuture<Optional<PlayerSkin>> getOrLoad(GameProfile p_294865_) {
        Property property = this.sessionService.getPackedTextures(p_294865_);
        return (CompletableFuture)this.skinCache.getUnchecked((Object)new CacheKey(p_294865_.getId(), property));
    }

    CompletableFuture<PlayerSkin> registerTextures(UUID p_307544_, MinecraftProfileTextures p_307606_) {
        PlayerSkin.Model playerskin$model;
        CompletableFuture<ResourceLocation> completablefuture;
        MinecraftProfileTexture minecraftprofiletexture = p_307606_.skin();
        if (minecraftprofiletexture != null) {
            completablefuture = this.skinTextures.getOrLoad(minecraftprofiletexture);
            playerskin$model = PlayerSkin.Model.byName(minecraftprofiletexture.getMetadata("model"));
        } else {
            PlayerSkin playerskin = DefaultPlayerSkin.get(p_307544_);
            completablefuture = CompletableFuture.completedFuture(playerskin.texture());
            playerskin$model = playerskin.model();
        }
        String s = Optionull.map(minecraftprofiletexture, MinecraftProfileTexture::getUrl);
        MinecraftProfileTexture minecraftprofiletexture1 = p_307606_.cape();
        CompletableFuture<Object> completablefuture1 = minecraftprofiletexture1 != null ? this.capeTextures.getOrLoad(minecraftprofiletexture1) : CompletableFuture.completedFuture(null);
        MinecraftProfileTexture minecraftprofiletexture2 = p_307606_.elytra();
        CompletableFuture<Object> completablefuture2 = minecraftprofiletexture2 != null ? this.elytraTextures.getOrLoad(minecraftprofiletexture2) : CompletableFuture.completedFuture(null);
        return CompletableFuture.allOf(completablefuture, completablefuture1, completablefuture2).thenApply(p_307126_ -> new PlayerSkin((ResourceLocation)completablefuture.join(), s, (ResourceLocation)completablefuture1.join(), (ResourceLocation)completablefuture2.join(), playerskin$model, p_307606_.signatureState() == SignatureState.SIGNED));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class TextureCache {
        private final Path root;
        private final MinecraftProfileTexture.Type type;
        private final Map<String, CompletableFuture<ResourceLocation>> textures = new Object2ObjectOpenHashMap();

        TextureCache(Path p_294453_, MinecraftProfileTexture.Type p_294220_) {
            this.root = p_294453_;
            this.type = p_294220_;
        }

        public CompletableFuture<ResourceLocation> getOrLoad(MinecraftProfileTexture p_294862_) {
            String s = p_294862_.getHash();
            CompletableFuture<ResourceLocation> completablefuture = this.textures.get(s);
            if (completablefuture == null) {
                completablefuture = this.registerTexture(p_294862_);
                this.textures.put(s, completablefuture);
            }
            return completablefuture;
        }

        private CompletableFuture<ResourceLocation> registerTexture(MinecraftProfileTexture p_295647_) {
            String s = Hashing.sha1().hashUnencodedChars((CharSequence)p_295647_.getHash()).toString();
            ResourceLocation resourcelocation = this.getTextureLocation(s);
            Path path = this.root.resolve(s.length() > 2 ? s.substring(0, 2) : "xx").resolve(s);
            return SkinTextureDownloader.downloadAndRegisterSkin(resourcelocation, path, p_295647_.getUrl(), this.type == MinecraftProfileTexture.Type.SKIN);
        }

        private ResourceLocation getTextureLocation(String p_295006_) {
            String s = switch (this.type) {
                default -> throw new MatchException(null, null);
                case MinecraftProfileTexture.Type.SKIN -> "skins";
                case MinecraftProfileTexture.Type.CAPE -> "capes";
                case MinecraftProfileTexture.Type.ELYTRA -> "elytra";
            };
            return ResourceLocation.withDefaultNamespace(s + "/" + p_295006_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record CacheKey(UUID profileId, @Nullable Property packedTextures) {
    }
}

