/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MapTextureManager
implements AutoCloseable {
    private final Int2ObjectMap<MapInstance> maps = new Int2ObjectOpenHashMap();
    final TextureManager textureManager;

    public MapTextureManager(TextureManager p_364440_) {
        this.textureManager = p_364440_;
    }

    public void update(MapId p_360802_, MapItemSavedData p_362966_) {
        this.getOrCreateMapInstance(p_360802_, p_362966_).forceUpload();
    }

    public ResourceLocation prepareMapTexture(MapId p_364272_, MapItemSavedData p_364454_) {
        MapInstance maptexturemanager$mapinstance = this.getOrCreateMapInstance(p_364272_, p_364454_);
        maptexturemanager$mapinstance.updateTextureIfNeeded();
        return maptexturemanager$mapinstance.location;
    }

    public void resetData() {
        for (MapInstance maptexturemanager$mapinstance : this.maps.values()) {
            maptexturemanager$mapinstance.close();
        }
        this.maps.clear();
    }

    private MapInstance getOrCreateMapInstance(MapId p_360665_, MapItemSavedData p_363475_) {
        return (MapInstance)this.maps.compute(p_360665_.id(), (p_362953_, p_362729_) -> {
            if (p_362729_ == null) {
                return new MapInstance(this, (int)p_362953_, p_363475_);
            }
            p_362729_.replaceMapData(p_363475_);
            return p_362729_;
        });
    }

    @Override
    public void close() {
        this.resetData();
    }

    @OnlyIn(value=Dist.CLIENT)
    class MapInstance
    implements AutoCloseable {
        private MapItemSavedData data;
        private final DynamicTexture texture;
        private boolean requiresUpload = true;
        final ResourceLocation location;

        MapInstance(MapTextureManager this$0, int p_362268_, MapItemSavedData p_362707_) {
            this.data = p_362707_;
            this.texture = new DynamicTexture(() -> "Map " + p_362268_, 128, 128, true);
            this.location = ResourceLocation.withDefaultNamespace("map/" + p_362268_);
            this$0.textureManager.register(this.location, this.texture);
        }

        void replaceMapData(MapItemSavedData p_361304_) {
            boolean flag = this.data != p_361304_;
            this.data = p_361304_;
            this.requiresUpload |= flag;
        }

        public void forceUpload() {
            this.requiresUpload = true;
        }

        void updateTextureIfNeeded() {
            if (this.requiresUpload) {
                NativeImage nativeimage = this.texture.getPixels();
                if (nativeimage != null) {
                    for (int i = 0; i < 128; ++i) {
                        for (int j = 0; j < 128; ++j) {
                            int k = j + i * 128;
                            nativeimage.setPixel(j, i, MapColor.getColorFromPackedId(this.data.colors[k]));
                        }
                    }
                }
                this.texture.upload();
                this.requiresUpload = false;
            }
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

