/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas.sources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public record SingleFile(ResourceLocation resourceId, Optional<ResourceLocation> spriteId) implements SpriteSource
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SingleFile> MAP_CODEC = RecordCodecBuilder.mapCodec(p_261903_ -> p_261903_.group((App)ResourceLocation.CODEC.fieldOf("resource").forGetter(SingleFile::resourceId), (App)ResourceLocation.CODEC.optionalFieldOf("sprite").forGetter(SingleFile::spriteId)).apply((Applicative)p_261903_, SingleFile::new));

    public SingleFile(ResourceLocation p_400289_) {
        this(p_400289_, Optional.empty());
    }

    @Override
    public void run(ResourceManager p_261920_, SpriteSource.Output p_261578_) {
        ResourceLocation resourcelocation = TEXTURE_ID_CONVERTER.idToFile(this.resourceId);
        Optional<Resource> optional = p_261920_.getResource(resourcelocation);
        if (optional.isPresent()) {
            p_261578_.add(this.spriteId.orElse(this.resourceId), optional.get());
        } else {
            LOGGER.warn("Missing sprite: {}", (Object)resourcelocation);
        }
    }

    public MapCodec<SingleFile> codec() {
        return MAP_CODEC;
    }
}

