/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas.sources;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.ARGB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public record PalettedPermutations(List<ResourceLocation> textures, ResourceLocation paletteKey, Map<String, ResourceLocation> permutations, String separator) implements SpriteSource
{
    static final Logger LOGGER = LogUtils.getLogger();
    public static final String DEFAULT_SEPARATOR = "_";
    public static final MapCodec<PalettedPermutations> MAP_CODEC = RecordCodecBuilder.mapCodec(p_399351_ -> p_399351_.group((App)Codec.list(ResourceLocation.CODEC).fieldOf("textures").forGetter(PalettedPermutations::textures), (App)ResourceLocation.CODEC.fieldOf("palette_key").forGetter(PalettedPermutations::paletteKey), (App)Codec.unboundedMap((Codec)Codec.STRING, ResourceLocation.CODEC).fieldOf("permutations").forGetter(PalettedPermutations::permutations), (App)Codec.STRING.optionalFieldOf("separator", (Object)DEFAULT_SEPARATOR).forGetter(PalettedPermutations::separator)).apply((Applicative)p_399351_, PalettedPermutations::new));

    public PalettedPermutations(List<ResourceLocation> p_267282_, ResourceLocation p_266681_, Map<String, ResourceLocation> p_266741_) {
        this(p_267282_, p_266681_, p_266741_, DEFAULT_SEPARATOR);
    }

    @Override
    public void run(ResourceManager p_267219_, SpriteSource.Output p_267250_) {
        Supplier supplier = Suppliers.memoize(() -> PalettedPermutations.loadPaletteEntryFromImage(p_267219_, this.paletteKey));
        HashMap map = new HashMap();
        this.permutations.forEach((arg_0, arg_1) -> PalettedPermutations.lambda$run$3(map, (java.util.function.Supplier)supplier, p_267219_, arg_0, arg_1));
        for (ResourceLocation resourcelocation : this.textures) {
            ResourceLocation resourcelocation1 = TEXTURE_ID_CONVERTER.idToFile(resourcelocation);
            Optional<Resource> optional = p_267219_.getResource(resourcelocation1);
            if (optional.isEmpty()) {
                LOGGER.warn("Unable to find texture {}", (Object)resourcelocation1);
                continue;
            }
            LazyLoadedImage lazyloadedimage = new LazyLoadedImage(resourcelocation1, optional.get(), map.size());
            for (Map.Entry entry : map.entrySet()) {
                ResourceLocation resourcelocation2 = resourcelocation.withSuffix(this.separator + (String)entry.getKey());
                p_267250_.add(resourcelocation2, new PalettedSpriteSupplier(lazyloadedimage, (java.util.function.Supplier)entry.getValue(), resourcelocation2));
            }
        }
    }

    private static IntUnaryOperator createPaletteMapping(int[] p_266839_, int[] p_266776_) {
        if (p_266776_.length != p_266839_.length) {
            LOGGER.warn("Palette mapping has different sizes: {} and {}", (Object)p_266839_.length, (Object)p_266776_.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap int2intmap = new Int2IntOpenHashMap(p_266776_.length);
        for (int i = 0; i < p_266839_.length; ++i) {
            int j = p_266839_[i];
            if (ARGB.alpha(j) == 0) continue;
            int2intmap.put(ARGB.transparent(j), p_266776_[i]);
        }
        return arg_0 -> PalettedPermutations.lambda$createPaletteMapping$4((Int2IntMap)int2intmap, arg_0);
    }

    private static int[] loadPaletteEntryFromImage(ResourceManager p_267184_, ResourceLocation p_267059_) {
        Optional<Resource> optional = p_267184_.getResource(TEXTURE_ID_CONVERTER.idToFile(p_267059_));
        if (optional.isEmpty()) {
            LOGGER.error("Failed to load palette image {}", (Object)p_267059_);
            throw new IllegalArgumentException();
        }
        try {
            int[] aint;
            try (InputStream inputstream = optional.get().open();
                 NativeImage nativeimage = NativeImage.read(inputstream);){
                aint = nativeimage.getPixels();
            }
            return aint;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load texture {}", (Object)p_267059_, (Object)exception);
            throw new IllegalArgumentException();
        }
    }

    public MapCodec<PalettedPermutations> codec() {
        return MAP_CODEC;
    }

    private static /* synthetic */ int lambda$createPaletteMapping$4(Int2IntMap int2intmap, int p_359295_) {
        int k = ARGB.alpha(p_359295_);
        if (k == 0) {
            return p_359295_;
        }
        int l = ARGB.transparent(p_359295_);
        int i1 = int2intmap.getOrDefault(l, ARGB.opaque(l));
        int j1 = ARGB.alpha(i1);
        return ARGB.color(k * j1 / 255, i1);
    }

    private static /* synthetic */ void lambda$run$3(Map map, java.util.function.Supplier supplier, ResourceManager p_267219_, String p_267108_, ResourceLocation p_266969_) {
        map.put(p_267108_, Suppliers.memoize(() -> PalettedPermutations.lambda$run$2((java.util.function.Supplier)supplier, p_267219_, p_266969_)));
    }

    private static /* synthetic */ IntUnaryOperator lambda$run$2(java.util.function.Supplier supplier, ResourceManager p_267219_, ResourceLocation p_266969_) {
        return PalettedPermutations.createPaletteMapping((int[])supplier.get(), PalettedPermutations.loadPaletteEntryFromImage(p_267219_, p_266969_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public record PalettedSpriteSupplier(LazyLoadedImage baseImage, java.util.function.Supplier<IntUnaryOperator> palette, ResourceLocation permutationLocation) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public SpriteContents apply(SpriteResourceLoader p_295023_) {
            Object object;
            try {
                NativeImage nativeimage = this.baseImage.get().mappedCopy(this.palette.get());
                SpriteContents spriteContents = new SpriteContents(this.permutationLocation, new FrameSize(nativeimage.getWidth(), nativeimage.getHeight()), nativeimage, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException | IllegalArgumentException ioexception) {
                LOGGER.error("unable to apply palette to {}", (Object)this.permutationLocation, (Object)ioexception);
                object = null;
            }
            finally {
                this.baseImage.release();
            }
            return object;
        }

        @Override
        public void discard() {
            this.baseImage.release();
        }
    }
}

