/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.SkullBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class PlayerHeadSpecialRenderer
implements SpecialModelRenderer<PlayerHeadRenderInfo> {
    private final Map<ResolvableProfile, PlayerHeadRenderInfo> updatedResolvableProfiles = new HashMap<ResolvableProfile, PlayerHeadRenderInfo>();
    private final SkinManager skinManager;
    private final SkullModelBase modelBase;
    private final PlayerHeadRenderInfo defaultPlayerHeadRenderInfo;

    PlayerHeadSpecialRenderer(SkinManager p_428227_, SkullModelBase p_428324_, PlayerHeadRenderInfo p_428497_) {
        this.skinManager = p_428227_;
        this.modelBase = p_428324_;
        this.defaultPlayerHeadRenderInfo = p_428497_;
    }

    @Override
    public void render(@Nullable PlayerHeadRenderInfo p_428304_, ItemDisplayContext p_428430_, PoseStack p_428478_, MultiBufferSource p_428438_, int p_428449_, int p_428317_, boolean p_428229_) {
        PlayerHeadRenderInfo playerheadspecialrenderer$playerheadrenderinfo = Objects.requireNonNullElse(p_428304_, this.defaultPlayerHeadRenderInfo);
        RenderType rendertype = playerheadspecialrenderer$playerheadrenderinfo.renderType();
        SkullBlockRenderer.renderSkull(null, 180.0f, 0.0f, p_428478_, p_428438_, p_428449_, this.modelBase, rendertype);
    }

    @Override
    public void getExtents(Set<Vector3f> p_428562_) {
        PoseStack posestack = new PoseStack();
        posestack.translate(0.5f, 0.0f, 0.5f);
        posestack.scale(-1.0f, -1.0f, 1.0f);
        this.modelBase.root().getExtentsForGui(posestack, p_428562_);
    }

    @Override
    @Nullable
    public PlayerHeadRenderInfo extractArgument(ItemStack p_428504_) {
        ResolvableProfile resolvableprofile = p_428504_.get(DataComponents.PROFILE);
        if (resolvableprofile == null) {
            return null;
        }
        PlayerHeadRenderInfo playerheadspecialrenderer$playerheadrenderinfo = this.updatedResolvableProfiles.get(resolvableprofile);
        if (playerheadspecialrenderer$playerheadrenderinfo != null) {
            return playerheadspecialrenderer$playerheadrenderinfo;
        }
        ResolvableProfile resolvableprofile1 = resolvableprofile.pollResolve();
        return resolvableprofile1 != null ? this.createAndCacheIfTextureIsUnpacked(resolvableprofile1) : null;
    }

    @Nullable
    private PlayerHeadRenderInfo createAndCacheIfTextureIsUnpacked(ResolvableProfile p_428356_) {
        PlayerSkin playerskin = this.skinManager.getInsecureSkin(p_428356_.gameProfile(), null);
        if (playerskin != null) {
            PlayerHeadRenderInfo playerheadspecialrenderer$playerheadrenderinfo = PlayerHeadRenderInfo.create(playerskin);
            this.updatedResolvableProfiles.put(p_428356_, playerheadspecialrenderer$playerheadrenderinfo);
            return playerheadspecialrenderer$playerheadrenderinfo;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record PlayerHeadRenderInfo(RenderType renderType) {
        static PlayerHeadRenderInfo create(PlayerSkin p_428337_) {
            return new PlayerHeadRenderInfo(SkullBlockRenderer.getPlayerSkinRenderType(p_428337_.texture()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @Override
        @Nullable
        public SpecialModelRenderer<?> bake(EntityModelSet p_428374_) {
            SkullModelBase skullmodelbase = SkullBlockRenderer.createModel(p_428374_, SkullBlock.Types.PLAYER);
            return skullmodelbase == null ? null : new PlayerHeadSpecialRenderer(Minecraft.getInstance().getSkinManager(), skullmodelbase, PlayerHeadRenderInfo.create(DefaultPlayerSkin.getDefaultSkin()));
        }
    }
}

