/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class HangingSignSpecialRenderer
implements NoDataSpecialModelRenderer {
    private final Model model;
    private final Material material;

    public HangingSignSpecialRenderer(Model p_389506_, Material p_389504_) {
        this.model = p_389506_;
        this.material = p_389504_;
    }

    @Override
    public void render(ItemDisplayContext p_389655_, PoseStack p_389572_, MultiBufferSource p_389478_, int p_389663_, int p_389449_, boolean p_389652_) {
        HangingSignRenderer.renderInHand(p_389572_, p_389478_, p_389663_, p_389449_, this.model, this.material);
    }

    @Override
    public void getExtents(Set<Vector3f> p_428224_) {
        PoseStack posestack = new PoseStack();
        HangingSignRenderer.translateBase(posestack, 0.0f);
        posestack.scale(1.0f, -1.0f, -1.0f);
        this.model.root().getExtentsForGui(posestack, p_428224_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(WoodType woodType, Optional<ResourceLocation> texture) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_389524_ -> p_389524_.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(Unbaked::woodType), (App)ResourceLocation.CODEC.optionalFieldOf("texture").forGetter(Unbaked::texture)).apply((Applicative)p_389524_, Unbaked::new));

        public Unbaked(WoodType p_389680_) {
            this(p_389680_, Optional.empty());
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @Override
        public SpecialModelRenderer<?> bake(EntityModelSet p_389408_) {
            Model model = HangingSignRenderer.createSignModel(p_389408_, this.woodType, HangingSignRenderer.AttachmentType.CEILING_MIDDLE);
            Material material = this.texture.map(Sheets.HANGING_SIGN_MAPPER::apply).orElseGet(() -> Sheets.getHangingSignMaterial(this.woodType));
            return new HangingSignSpecialRenderer(model, material);
        }
    }
}

