/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item.properties.select;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public record ComponentContents<T>(DataComponentType<T> componentType) implements SelectItemModelProperty<T>
{
    private static final SelectItemModelProperty.Type<? extends ComponentContents<?>, ?> TYPE = ComponentContents.createType();

    private static <T> SelectItemModelProperty.Type<ComponentContents<T>, T> createType() {
        Codec codec = BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec().validate(p_398049_ -> p_398049_.isTransient() ? DataResult.error(() -> "Component can't be serialized") : DataResult.success((Object)p_398049_));
        MapCodec mapcodec = codec.dispatchMap("component", p_397332_ -> ((ComponentContents)p_397332_.property()).componentType, p_397367_ -> SelectItemModelProperty.Type.createCasesFieldCodec(p_397367_.codecOrThrow()).xmap(p_397778_ -> new SelectItemModel.UnbakedSwitch(new ComponentContents(p_397367_), p_397778_), SelectItemModel.UnbakedSwitch::cases));
        return new SelectItemModelProperty.Type(mapcodec);
    }

    public static <T> SelectItemModelProperty.Type<ComponentContents<T>, T> castType() {
        return TYPE;
    }

    @Override
    @Nullable
    public T get(ItemStack p_397602_, @Nullable ClientLevel p_397414_, @Nullable LivingEntity p_397883_, int p_397032_, ItemDisplayContext p_397548_) {
        return p_397602_.get(this.componentType);
    }

    @Override
    public SelectItemModelProperty.Type<ComponentContents<T>, T> type() {
        return ComponentContents.castType();
    }

    @Override
    public Codec<T> valueCodec() {
        return this.componentType.codecOrThrow();
    }
}

