/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item.properties.numeric;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class NeedleDirectionHelper {
    private final boolean wobble;

    protected NeedleDirectionHelper(boolean p_388777_) {
        this.wobble = p_388777_;
    }

    public float get(ItemStack p_386635_, @Nullable ClientLevel p_387256_, @Nullable LivingEntity p_388745_, int p_387873_) {
        Level level;
        Entity entity;
        Entity entity2 = entity = p_388745_ != null ? p_388745_ : p_386635_.getEntityRepresentation();
        if (entity == null) {
            return 0.0f;
        }
        if (p_387256_ == null && (level = entity.level()) instanceof ClientLevel) {
            ClientLevel clientlevel;
            p_387256_ = clientlevel = (ClientLevel)level;
        }
        return p_387256_ == null ? 0.0f : this.calculate(p_386635_, p_387256_, p_387873_, entity);
    }

    protected abstract float calculate(ItemStack var1, ClientLevel var2, int var3, Entity var4);

    protected boolean wobble() {
        return this.wobble;
    }

    protected Wobbler newWobbler(float p_387658_) {
        return this.wobble ? NeedleDirectionHelper.standardWobbler(p_387658_) : NeedleDirectionHelper.nonWobbler();
    }

    public static Wobbler standardWobbler(final float p_388906_) {
        return new Wobbler(){
            private float rotation;
            private float deltaRotation;
            private long lastUpdateTick;

            @Override
            public float rotation() {
                return this.rotation;
            }

            @Override
            public boolean shouldUpdate(long p_387925_) {
                return this.lastUpdateTick != p_387925_;
            }

            @Override
            public void update(long p_387682_, float p_388243_) {
                this.lastUpdateTick = p_387682_;
                float f = Mth.positiveModulo(p_388243_ - this.rotation + 0.5f, 1.0f) - 0.5f;
                this.deltaRotation += f * 0.1f;
                this.deltaRotation *= p_388906_;
                this.rotation = Mth.positiveModulo(this.rotation + this.deltaRotation, 1.0f);
            }
        };
    }

    public static Wobbler nonWobbler() {
        return new Wobbler(){
            private float targetValue;

            @Override
            public float rotation() {
                return this.targetValue;
            }

            @Override
            public boolean shouldUpdate(long p_388006_) {
                return true;
            }

            @Override
            public void update(long p_388810_, float p_387609_) {
                this.targetValue = p_387609_;
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Wobbler {
        public float rotation();

        public boolean shouldUpdate(long var1);

        public void update(long var1, float var3);
    }
}

