/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderers;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class SpecialModelWrapper<T>
implements ItemModel {
    private final SpecialModelRenderer<T> specialRenderer;
    private final ModelRenderProperties properties;

    public SpecialModelWrapper(SpecialModelRenderer<T> p_387041_, ModelRenderProperties p_405384_) {
        this.specialRenderer = p_387041_;
        this.properties = p_405384_;
    }

    @Override
    public void update(ItemStackRenderState p_388134_, ItemStack p_387781_, ItemModelResolver p_387931_, ItemDisplayContext p_388057_, @Nullable ClientLevel p_388213_, @Nullable LivingEntity p_388020_, int p_387759_) {
        p_388134_.appendModelIdentityElement(this);
        ItemStackRenderState.LayerRenderState itemstackrenderstate$layerrenderstate = p_388134_.newLayer();
        if (p_387781_.hasFoil()) {
            ItemStackRenderState.FoilType itemstackrenderstate$foiltype = ItemStackRenderState.FoilType.STANDARD;
            itemstackrenderstate$layerrenderstate.setFoilType(itemstackrenderstate$foiltype);
            p_388134_.setAnimated();
            p_388134_.appendModelIdentityElement((Object)itemstackrenderstate$foiltype);
        }
        T t = this.specialRenderer.extractArgument(p_387781_);
        itemstackrenderstate$layerrenderstate.setExtents(() -> {
            HashSet<Vector3f> set = new HashSet<Vector3f>();
            this.specialRenderer.getExtents(set);
            return set.toArray(new Vector3f[0]);
        });
        itemstackrenderstate$layerrenderstate.setupSpecialModel(this.specialRenderer, t);
        if (t != null) {
            p_388134_.appendModelIdentityElement(t);
        }
        this.properties.applyToLayer(itemstackrenderstate$layerrenderstate, p_388057_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(ResourceLocation base, SpecialModelRenderer.Unbaked specialModel) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_386693_ -> p_386693_.group((App)ResourceLocation.CODEC.fieldOf("base").forGetter(Unbaked::base), (App)SpecialModelRenderers.CODEC.fieldOf("model").forGetter(Unbaked::specialModel)).apply((Applicative)p_386693_, Unbaked::new));

        @Override
        public void resolveDependencies(ResolvableModel.Resolver p_387171_) {
            p_387171_.markDependency(this.base);
        }

        @Override
        public ItemModel bake(ItemModel.BakingContext p_388760_) {
            SpecialModelRenderer<?> specialmodelrenderer = this.specialModel.bake(p_388760_.entityModelSet());
            if (specialmodelrenderer == null) {
                return p_388760_.missingItemModel();
            }
            ModelRenderProperties modelrenderproperties = this.getProperties(p_388760_);
            return new SpecialModelWrapper(specialmodelrenderer, modelrenderproperties);
        }

        private ModelRenderProperties getProperties(ItemModel.BakingContext p_404963_) {
            ModelBaker modelbaker = p_404963_.blockModelBaker();
            ResolvedModel resolvedmodel = modelbaker.getModel(this.base);
            TextureSlots textureslots = resolvedmodel.getTopTextureSlots();
            return ModelRenderProperties.fromResolvedModel(modelbaker, resolvedmodel, textureslots);
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

