/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class MissingItemModel
implements ItemModel {
    private final List<BakedQuad> quads;
    private final Supplier<Vector3f[]> extents;
    private final ModelRenderProperties properties;

    public MissingItemModel(List<BakedQuad> p_404765_, ModelRenderProperties p_404921_) {
        this.quads = p_404765_;
        this.properties = p_404921_;
        this.extents = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(this.quads));
    }

    @Override
    public void update(ItemStackRenderState p_386627_, ItemStack p_388292_, ItemModelResolver p_388302_, ItemDisplayContext p_388518_, @Nullable ClientLevel p_387367_, @Nullable LivingEntity p_388182_, int p_388913_) {
        p_386627_.appendModelIdentityElement(this);
        ItemStackRenderState.LayerRenderState itemstackrenderstate$layerrenderstate = p_386627_.newLayer();
        itemstackrenderstate$layerrenderstate.setRenderType(Sheets.cutoutBlockSheet());
        this.properties.applyToLayer(itemstackrenderstate$layerrenderstate, p_388518_);
        itemstackrenderstate$layerrenderstate.setExtents(this.extents);
        itemstackrenderstate$layerrenderstate.prepareQuadList().addAll(this.quads);
    }
}

