/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.CacheSlot;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemModels;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperties;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.conditional.ItemModelPropertyTest;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.util.RegistryContextSwapper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConditionalItemModel
implements ItemModel {
    private final ItemModelPropertyTest property;
    private final ItemModel onTrue;
    private final ItemModel onFalse;

    public ConditionalItemModel(ItemModelPropertyTest p_400221_, ItemModel p_387738_, ItemModel p_388649_) {
        this.property = p_400221_;
        this.onTrue = p_387738_;
        this.onFalse = p_388649_;
    }

    @Override
    public void update(ItemStackRenderState p_387756_, ItemStack p_387286_, ItemModelResolver p_386644_, ItemDisplayContext p_387754_, @Nullable ClientLevel p_388301_, @Nullable LivingEntity p_387078_, int p_387025_) {
        p_387756_.appendModelIdentityElement(this);
        (this.property.get(p_387286_, p_388301_, p_387078_, p_387025_, p_387754_) ? this.onTrue : this.onFalse).update(p_387756_, p_387286_, p_386644_, p_387754_, p_388301_, p_387078_, p_387025_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(ConditionalItemModelProperty property, ItemModel.Unbaked onTrue, ItemModel.Unbaked onFalse) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_388916_ -> p_388916_.group((App)ConditionalItemModelProperties.MAP_CODEC.forGetter(Unbaked::property), (App)ItemModels.CODEC.fieldOf("on_true").forGetter(Unbaked::onTrue), (App)ItemModels.CODEC.fieldOf("on_false").forGetter(Unbaked::onFalse)).apply((Applicative)p_388916_, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @Override
        public ItemModel bake(ItemModel.BakingContext p_388309_) {
            return new ConditionalItemModel(this.adaptProperty(this.property, p_388309_.contextSwapper()), this.onTrue.bake(p_388309_), this.onFalse.bake(p_388309_));
        }

        private ItemModelPropertyTest adaptProperty(ConditionalItemModelProperty p_399789_, @Nullable RegistryContextSwapper p_400165_) {
            if (p_400165_ == null) {
                return p_399789_;
            }
            CacheSlot<ClientLevel, ItemModelPropertyTest> cacheslot = new CacheSlot<ClientLevel, ItemModelPropertyTest>(p_399329_ -> Unbaked.swapContext(p_399789_, p_400165_, p_399329_));
            return (p_399322_, p_399323_, p_399324_, p_399325_, p_399326_) -> {
                ConditionalItemModelProperty itemmodelpropertytest = p_399323_ == null ? p_399789_ : (ItemModelPropertyTest)cacheslot.compute(p_399323_);
                return itemmodelpropertytest.get(p_399322_, p_399323_, p_399324_, p_399325_, p_399326_);
            };
        }

        private static <T extends ConditionalItemModelProperty> T swapContext(T p_399529_, RegistryContextSwapper p_399879_, ClientLevel p_399861_) {
            return p_399879_.swapTo(p_399529_.type().codec(), p_399529_, p_399861_.registryAccess()).result().orElse(p_399529_);
        }

        @Override
        public void resolveDependencies(ResolvableModel.Resolver p_388796_) {
            this.onTrue.resolveDependencies(p_388796_);
            this.onFalse.resolveDependencies(p_388796_);
        }
    }
}

