/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemModels;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompositeModel
implements ItemModel {
    private final List<ItemModel> models;

    public CompositeModel(List<ItemModel> p_388744_) {
        this.models = p_388744_;
    }

    @Override
    public void update(ItemStackRenderState p_386893_, ItemStack p_387281_, ItemModelResolver p_388412_, ItemDisplayContext p_388059_, @Nullable ClientLevel p_388484_, @Nullable LivingEntity p_388840_, int p_387330_) {
        p_386893_.appendModelIdentityElement(this);
        p_386893_.ensureCapacity(this.models.size());
        for (ItemModel itemmodel : this.models) {
            itemmodel.update(p_386893_, p_387281_, p_388412_, p_388059_, p_388484_, p_388840_, p_387330_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(List<ItemModel.Unbaked> models) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_388702_ -> p_388702_.group((App)ItemModels.CODEC.listOf().fieldOf("models").forGetter(Unbaked::models)).apply((Applicative)p_388702_, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @Override
        public void resolveDependencies(ResolvableModel.Resolver p_387836_) {
            for (ItemModel.Unbaked itemmodel$unbaked : this.models) {
                itemmodel$unbaked.resolveDependencies(p_387836_);
            }
        }

        @Override
        public ItemModel bake(ItemModel.BakingContext p_388240_) {
            return new CompositeModel(this.models.stream().map(p_387424_ -> p_387424_.bake(p_388240_)).toList());
        }
    }
}

