/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.fog.environment;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.MobEffectFogEnvironment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlindnessFogEnvironment
extends MobEffectFogEnvironment {
    @Override
    public Holder<MobEffect> getMobEffect() {
        return MobEffects.BLINDNESS;
    }

    @Override
    public void setupFog(FogData p_423496_, Entity p_423549_, BlockPos p_423480_, ClientLevel p_423609_, float p_423576_, DeltaTracker p_423570_) {
        LivingEntity livingentity;
        MobEffectInstance mobeffectinstance;
        if (p_423549_ instanceof LivingEntity && (mobeffectinstance = (livingentity = (LivingEntity)p_423549_).getEffect(this.getMobEffect())) != null) {
            float f = mobeffectinstance.isInfiniteDuration() ? 5.0f : Mth.lerp(Math.min(1.0f, (float)mobeffectinstance.getDuration() / 20.0f), p_423576_, 5.0f);
            p_423496_.environmentalStart = f * 0.25f;
            p_423496_.environmentalEnd = f;
            p_423496_.skyEnd = f * 0.8f;
            p_423496_.cloudEnd = f * 0.8f;
        }
    }

    @Override
    public float getModifiedDarkness(LivingEntity p_423634_, float p_423626_, float p_423501_) {
        MobEffectInstance mobeffectinstance = p_423634_.getEffect(this.getMobEffect());
        if (mobeffectinstance != null) {
            p_423626_ = mobeffectinstance.endsWithin(19) ? Math.max((float)mobeffectinstance.getDuration() / 20.0f, p_423626_) : 1.0f;
        }
        return p_423626_;
    }
}

