/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.fog;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MappableRingBuffer;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.AtmosphericFogEnvironment;
import net.minecraft.client.renderer.fog.environment.BlindnessFogEnvironment;
import net.minecraft.client.renderer.fog.environment.DarknessFogEnvironment;
import net.minecraft.client.renderer.fog.environment.DimensionOrBossFogEnvironment;
import net.minecraft.client.renderer.fog.environment.FogEnvironment;
import net.minecraft.client.renderer.fog.environment.LavaFogEnvironment;
import net.minecraft.client.renderer.fog.environment.PowderedSnowFogEnvironment;
import net.minecraft.client.renderer.fog.environment.WaterFogEnvironment;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class FogRenderer
implements AutoCloseable {
    public static final int FOG_UBO_SIZE = new Std140SizeCalculator().putVec4().putFloat().putFloat().putFloat().putFloat().putFloat().putFloat().get();
    private static final List<FogEnvironment> FOG_ENVIRONMENTS = Lists.newArrayList((Object[])new FogEnvironment[]{new LavaFogEnvironment(), new PowderedSnowFogEnvironment(), new BlindnessFogEnvironment(), new DarknessFogEnvironment(), new WaterFogEnvironment(), new DimensionOrBossFogEnvironment(), new AtmosphericFogEnvironment()});
    private static boolean fogEnabled = true;
    private final GpuBuffer emptyBuffer;
    private final MappableRingBuffer regularBuffer;

    public FogRenderer() {
        GpuDevice gpudevice = RenderSystem.getDevice();
        this.regularBuffer = new MappableRingBuffer(() -> "Fog UBO", 130, FOG_UBO_SIZE);
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(FOG_UBO_SIZE);
            this.updateBuffer(bytebuffer, 0, new Vector4f(0.0f), Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            this.emptyBuffer = gpudevice.createBuffer(() -> "Empty fog", 128, bytebuffer.flip());
        }
        RenderSystem.setShaderFog(this.getBuffer(FogMode.NONE));
    }

    @Override
    public void close() {
        this.emptyBuffer.close();
        this.regularBuffer.close();
    }

    public void endFrame() {
        this.regularBuffer.rotate();
    }

    public GpuBufferSlice getBuffer(FogMode p_423591_) {
        if (!fogEnabled) {
            return this.emptyBuffer.slice(0, FOG_UBO_SIZE);
        }
        return switch (p_423591_.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.emptyBuffer.slice(0, FOG_UBO_SIZE);
            case 1 -> this.regularBuffer.currentBuffer().slice(0, FOG_UBO_SIZE);
        };
    }

    private Vector4f computeFogColor(Camera p_423439_, float p_423466_, ClientLevel p_423475_, int p_423484_, float p_423652_, boolean p_423514_) {
        LivingEntity livingentity1;
        FogType fogtype = this.getFogType(p_423439_, p_423514_);
        Entity entity = p_423439_.getEntity();
        FogEnvironment fogenvironment = null;
        FogEnvironment fogenvironment1 = null;
        for (FogEnvironment fogenvironment2 : FOG_ENVIRONMENTS) {
            if (fogenvironment2.isApplicable(fogtype, entity)) {
                if (fogenvironment == null && fogenvironment2.providesColor()) {
                    fogenvironment = fogenvironment2;
                }
                if (fogenvironment1 != null || !fogenvironment2.modifiesDarkness()) continue;
                fogenvironment1 = fogenvironment2;
                continue;
            }
            fogenvironment2.onNotApplicable();
        }
        if (fogenvironment == null) {
            throw new IllegalStateException("No color source environment found");
        }
        int i = fogenvironment.getBaseColor(p_423475_, p_423439_, p_423484_, p_423652_);
        float f4 = p_423475_.getLevelData().voidDarknessOnsetRange();
        float f = Mth.clamp((f4 + (float)p_423475_.getMinY() - (float)p_423439_.getPosition().y) / f4, 0.0f, 1.0f);
        if (fogenvironment1 != null) {
            LivingEntity livingentity = (LivingEntity)entity;
            f = fogenvironment1.getModifiedDarkness(livingentity, f, p_423466_);
        }
        float f5 = ARGB.redFloat(i);
        float f1 = ARGB.greenFloat(i);
        float f2 = ARGB.blueFloat(i);
        if (f > 0.0f && fogtype != FogType.LAVA && fogtype != FogType.POWDER_SNOW) {
            float f3 = Mth.square(1.0f - f);
            f5 *= f3;
            f1 *= f3;
            f2 *= f3;
        }
        if (p_423652_ > 0.0f) {
            f5 = Mth.lerp(p_423652_, f5, f5 * 0.7f);
            f1 = Mth.lerp(p_423652_, f1, f1 * 0.6f);
            f2 = Mth.lerp(p_423652_, f2, f2 * 0.6f);
        }
        float f6 = fogtype == FogType.WATER ? (entity instanceof LocalPlayer ? ((LocalPlayer)entity).getWaterVision() : 1.0f) : (entity instanceof LivingEntity && (livingentity1 = (LivingEntity)entity).hasEffect(MobEffects.NIGHT_VISION) && !livingentity1.hasEffect(MobEffects.DARKNESS) ? GameRenderer.getNightVisionScale(livingentity1, p_423466_) : 0.0f);
        if (f5 != 0.0f && f1 != 0.0f && f2 != 0.0f) {
            float f7 = 1.0f / Math.max(f5, Math.max(f1, f2));
            f5 = Mth.lerp(f6, f5, f5 * f7);
            f1 = Mth.lerp(f6, f1, f1 * f7);
            f2 = Mth.lerp(f6, f2, f2 * f7);
        }
        return ClientHooks.getFogColor((Camera)p_423439_, (float)p_423466_, (ClientLevel)p_423475_, (int)p_423484_, (float)p_423652_, (float)f5, (float)f1, (float)f2);
    }

    public static boolean toggleFog() {
        fogEnabled = !fogEnabled;
        return fogEnabled;
    }

    public Vector4f setupFog(Camera p_423468_, int p_423600_, boolean p_423509_, DeltaTracker p_423597_, float p_423506_, ClientLevel p_423641_) {
        float f = p_423597_.getGameTimeDeltaPartialTick(false);
        Vector4f vector4f = this.computeFogColor(p_423468_, f, p_423641_, p_423600_, p_423506_, p_423509_);
        float f1 = p_423600_ * 16;
        FogType fogtype = this.getFogType(p_423468_, p_423509_);
        Entity entity = p_423468_.getEntity();
        FogData fogdata = new FogData();
        FogEnvironment chosenEnvironment = null;
        for (FogEnvironment fogenvironment : FOG_ENVIRONMENTS) {
            if (!fogenvironment.isApplicable(fogtype, entity)) continue;
            fogenvironment.setupFog(fogdata, entity, p_423468_.getBlockPosition(), p_423641_, f1, p_423597_);
            chosenEnvironment = fogenvironment;
            break;
        }
        float f2 = Mth.clamp(f1 / 10.0f, 4.0f, 64.0f);
        fogdata.renderDistanceStart = f1 - f2;
        fogdata.renderDistanceEnd = f1;
        ClientHooks.onSetupFog((FogEnvironment)chosenEnvironment, (FogType)fogtype, (Camera)p_423468_, (float)f, (float)p_423600_, (FogData)fogdata);
        try (GpuBuffer.MappedView gpubuffer$mappedview = RenderSystem.getDevice().createCommandEncoder().mapBuffer(this.regularBuffer.currentBuffer(), false, true);){
            this.updateBuffer(gpubuffer$mappedview.data(), 0, vector4f, fogdata.environmentalStart, fogdata.environmentalEnd, fogdata.renderDistanceStart, fogdata.renderDistanceEnd, fogdata.skyEnd, fogdata.cloudEnd);
        }
        return vector4f;
    }

    private FogType getFogType(Camera p_423451_, boolean p_423431_) {
        FogType fogtype = p_423451_.getFluidInCamera();
        if (fogtype == FogType.NONE) {
            return p_423431_ ? FogType.DIMENSION_OR_BOSS : FogType.ATMOSPHERIC;
        }
        return fogtype;
    }

    private void updateBuffer(ByteBuffer p_423489_, int p_423628_, Vector4f p_423543_, float p_423485_, float p_423650_, float p_423492_, float p_423500_, float p_423575_, float p_423452_) {
        p_423489_.position(p_423628_);
        Std140Builder.intoBuffer(p_423489_).putVec4((Vector4fc)p_423543_).putFloat(p_423485_).putFloat(p_423650_).putFloat(p_423492_).putFloat(p_423500_).putFloat(p_423575_).putFloat(p_423452_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum FogMode {
        NONE,
        WORLD;

    }
}

