/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerLikeModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.VillagerDataHolderRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.VillagerMetadataSection;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VillagerProfessionLayer<S extends LivingEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private static final Int2ObjectMap<ResourceLocation> LEVEL_LOCATIONS = (Int2ObjectMap)Util.make(new Int2ObjectOpenHashMap(), p_349909_ -> {
        p_349909_.put(1, (Object)ResourceLocation.withDefaultNamespace("stone"));
        p_349909_.put(2, (Object)ResourceLocation.withDefaultNamespace("iron"));
        p_349909_.put(3, (Object)ResourceLocation.withDefaultNamespace("gold"));
        p_349909_.put(4, (Object)ResourceLocation.withDefaultNamespace("emerald"));
        p_349909_.put(5, (Object)ResourceLocation.withDefaultNamespace("diamond"));
    });
    private final Object2ObjectMap<ResourceKey<VillagerType>, VillagerMetadataSection.Hat> typeHatCache = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<ResourceKey<VillagerProfession>, VillagerMetadataSection.Hat> professionHatCache = new Object2ObjectOpenHashMap();
    private final ResourceManager resourceManager;
    private final String path;

    public VillagerProfessionLayer(RenderLayerParent<S, M> p_174550_, ResourceManager p_174551_, String p_174552_) {
        super(p_174550_);
        this.resourceManager = p_174551_;
        this.path = p_174552_;
    }

    @Override
    public void render(PoseStack p_117646_, MultiBufferSource p_117647_, int p_117648_, S p_360821_, float p_117650_, float p_117651_) {
        VillagerData villagerdata;
        if (!((LivingEntityRenderState)((Object)p_360821_)).isInvisible && (villagerdata = ((VillagerDataHolderRenderState)p_360821_).getVillagerData()) != null) {
            Holder<VillagerType> holder = villagerdata.type();
            Holder<VillagerProfession> holder1 = villagerdata.profession();
            VillagerMetadataSection.Hat villagermetadatasection$hat = this.getHatData(this.typeHatCache, "type", holder);
            VillagerMetadataSection.Hat villagermetadatasection$hat1 = this.getHatData(this.professionHatCache, "profession", holder1);
            Object m = this.getParentModel();
            ((VillagerLikeModel)m).hatVisible(villagermetadatasection$hat1 == VillagerMetadataSection.Hat.NONE || villagermetadatasection$hat1 == VillagerMetadataSection.Hat.PARTIAL && villagermetadatasection$hat != VillagerMetadataSection.Hat.FULL);
            ResourceLocation resourcelocation = this.getResourceLocation("type", holder);
            VillagerProfessionLayer.renderColoredCutoutModel(m, resourcelocation, p_117646_, p_117647_, p_117648_, p_360821_, -1);
            ((VillagerLikeModel)m).hatVisible(true);
            if (!holder1.is(VillagerProfession.NONE) && !((LivingEntityRenderState)((Object)p_360821_)).isBaby) {
                ResourceLocation resourcelocation1 = this.getResourceLocation("profession", holder1);
                VillagerProfessionLayer.renderColoredCutoutModel(m, resourcelocation1, p_117646_, p_117647_, p_117648_, p_360821_, -1);
                if (!holder1.is(VillagerProfession.NITWIT)) {
                    ResourceLocation resourcelocation2 = this.getResourceLocation("profession_level", (ResourceLocation)LEVEL_LOCATIONS.get(Mth.clamp(villagerdata.level(), 1, LEVEL_LOCATIONS.size())));
                    VillagerProfessionLayer.renderColoredCutoutModel(m, resourcelocation2, p_117646_, p_117647_, p_117648_, p_360821_, -1);
                }
            }
        }
    }

    private ResourceLocation getResourceLocation(String p_117669_, ResourceLocation p_117670_) {
        return p_117670_.withPath(p_247944_ -> "textures/entity/" + this.path + "/" + p_117669_ + "/" + p_247944_ + ".png");
    }

    private ResourceLocation getResourceLocation(String p_397798_, Holder<?> p_398050_) {
        return p_398050_.unwrapKey().map(p_396316_ -> this.getResourceLocation(p_397798_, p_396316_.location())).orElse(MissingTextureAtlasSprite.getLocation());
    }

    public <K> VillagerMetadataSection.Hat getHatData(Object2ObjectMap<ResourceKey<K>, VillagerMetadataSection.Hat> p_117659_, String p_117660_, Holder<K> p_397530_) {
        ResourceKey resourcekey = p_397530_.unwrapKey().orElse(null);
        return resourcekey == null ? VillagerMetadataSection.Hat.NONE : (VillagerMetadataSection.Hat)p_117659_.computeIfAbsent((Object)resourcekey, p_396314_ -> this.resourceManager.getResource(this.getResourceLocation(p_117660_, resourcekey.location())).flatMap(p_389338_ -> {
            try {
                return p_389338_.metadata().getSection(VillagerMetadataSection.TYPE).map(VillagerMetadataSection::hat);
            }
            catch (IOException ioexception) {
                return Optional.empty();
            }
        }).orElse(VillagerMetadataSection.Hat.NONE));
    }
}

