/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class StuckInBodyLayer<M extends PlayerModel>
extends RenderLayer<PlayerRenderState, M> {
    private final Model model;
    private final ResourceLocation texture;
    private final PlacementStyle placementStyle;

    public StuckInBodyLayer(LivingEntityRenderer<?, PlayerRenderState, M> p_117564_, Model p_360318_, ResourceLocation p_363540_, PlacementStyle p_364028_) {
        super(p_117564_);
        this.model = p_360318_;
        this.texture = p_363540_;
        this.placementStyle = p_364028_;
    }

    protected abstract int numStuck(PlayerRenderState var1);

    private void renderStuckItem(PoseStack p_117566_, MultiBufferSource p_117567_, int p_117568_, float p_117570_, float p_117571_, float p_117572_) {
        float f = Mth.sqrt(p_117570_ * p_117570_ + p_117572_ * p_117572_);
        float f1 = (float)(Math.atan2(p_117570_, p_117572_) * 180.0 / 3.1415927410125732);
        float f2 = (float)(Math.atan2(p_117571_, f) * 180.0 / 3.1415927410125732);
        p_117566_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f1 - 90.0f));
        p_117566_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f2));
        this.model.renderToBuffer(p_117566_, p_117567_.getBuffer(this.model.renderType(this.texture)), p_117568_, OverlayTexture.NO_OVERLAY);
    }

    @Override
    public void render(PoseStack p_117575_, MultiBufferSource p_117576_, int p_117577_, PlayerRenderState p_363391_, float p_117579_, float p_117580_) {
        int i = this.numStuck(p_363391_);
        if (i > 0) {
            RandomSource randomsource = RandomSource.create(p_363391_.id);
            for (int j = 0; j < i; ++j) {
                p_117575_.pushPose();
                ModelPart modelpart = ((PlayerModel)this.getParentModel()).getRandomBodyPart(randomsource);
                ModelPart.Cube modelpart$cube = modelpart.getRandomCube(randomsource);
                modelpart.translateAndRotate(p_117575_);
                float f = randomsource.nextFloat();
                float f1 = randomsource.nextFloat();
                float f2 = randomsource.nextFloat();
                if (this.placementStyle == PlacementStyle.ON_SURFACE) {
                    int k = randomsource.nextInt(3);
                    switch (k) {
                        case 0: {
                            f = StuckInBodyLayer.snapToFace(f);
                            break;
                        }
                        case 1: {
                            f1 = StuckInBodyLayer.snapToFace(f1);
                            break;
                        }
                        default: {
                            f2 = StuckInBodyLayer.snapToFace(f2);
                        }
                    }
                }
                p_117575_.translate(Mth.lerp(f, modelpart$cube.minX, modelpart$cube.maxX) / 16.0f, Mth.lerp(f1, modelpart$cube.minY, modelpart$cube.maxY) / 16.0f, Mth.lerp(f2, modelpart$cube.minZ, modelpart$cube.maxZ) / 16.0f);
                this.renderStuckItem(p_117575_, p_117576_, p_117577_, -(f * 2.0f - 1.0f), -(f1 * 2.0f - 1.0f), -(f2 * 2.0f - 1.0f));
                p_117575_.popPose();
            }
        }
    }

    private static float snapToFace(float p_361108_) {
        return p_361108_ > 0.5f ? 1.0f : 0.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum PlacementStyle {
        IN_CUBE,
        ON_SURFACE;

    }
}

