/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.SnowGolemRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class SnowGolemHeadLayer
extends RenderLayer<SnowGolemRenderState, SnowGolemModel> {
    private final BlockRenderDispatcher blockRenderer;

    public SnowGolemHeadLayer(RenderLayerParent<SnowGolemRenderState, SnowGolemModel> p_234871_, BlockRenderDispatcher p_234872_) {
        super(p_234871_);
        this.blockRenderer = p_234872_;
    }

    @Override
    public void render(PoseStack p_117483_, MultiBufferSource p_117484_, int p_117485_, SnowGolemRenderState p_388156_, float p_117487_, float p_117488_) {
        if (p_388156_.hasPumpkin && (!p_388156_.isInvisible || p_388156_.appearsGlowing)) {
            p_117483_.pushPose();
            ((SnowGolemModel)this.getParentModel()).getHead().translateAndRotate(p_117483_);
            float f = 0.625f;
            p_117483_.translate(0.0f, -0.34375f, 0.0f);
            p_117483_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            p_117483_.scale(0.625f, -0.625f, -0.625f);
            BlockState blockstate = Blocks.CARVED_PUMPKIN.defaultBlockState();
            BlockStateModel blockstatemodel = this.blockRenderer.getBlockModel(blockstate);
            int i = LivingEntityRenderer.getOverlayCoords(p_388156_, 0.0f);
            p_117483_.translate(-0.5f, -0.5f, -0.5f);
            VertexConsumer vertexconsumer = p_388156_.appearsGlowing && p_388156_.isInvisible ? p_117484_.getBuffer(RenderType.outline(TextureAtlas.LOCATION_BLOCKS)) : p_117484_.getBuffer(ItemBlockRenderTypes.getRenderType(blockstate));
            ModelBlockRenderer.renderModel(p_117483_.last(), vertexconsumer, blockstatemodel, 0.0f, 0.0f, 0.0f, p_117485_, i);
            p_117483_.popPose();
        }
    }
}

