/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerItemInHandLayer<S extends PlayerRenderState, M extends EntityModel<S> & HeadedModel>
extends ItemInHandLayer<S, M> {
    private static final float X_ROT_MIN = -0.5235988f;
    private static final float X_ROT_MAX = 1.5707964f;

    public PlayerItemInHandLayer(RenderLayerParent<S, M> p_234866_) {
        super(p_234866_);
    }

    @Override
    protected void renderArmWithItem(S p_363789_, ItemStackRenderState p_386948_, HumanoidArm p_365271_, PoseStack p_362346_, MultiBufferSource p_360927_, int p_362805_) {
        if (!p_386948_.isEmpty()) {
            InteractionHand interactionhand;
            InteractionHand interactionHand = interactionhand = p_365271_ == ((PlayerRenderState)((Object)p_363789_)).mainArm ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            if (((PlayerRenderState)((Object)p_363789_)).isUsingItem && ((PlayerRenderState)((Object)p_363789_)).useItemHand == interactionhand && ((PlayerRenderState)((Object)p_363789_)).attackTime < 1.0E-5f && !((PlayerRenderState)((Object)p_363789_)).heldOnHead.isEmpty()) {
                this.renderItemHeldToEye(((PlayerRenderState)((Object)p_363789_)).heldOnHead, p_365271_, p_362346_, p_360927_, p_362805_);
            } else {
                super.renderArmWithItem(p_363789_, p_386948_, p_365271_, p_362346_, p_360927_, p_362805_);
            }
        }
    }

    private void renderItemHeldToEye(ItemStackRenderState p_386957_, HumanoidArm p_388092_, PoseStack p_388896_, MultiBufferSource p_386448_, int p_388927_) {
        p_388896_.pushPose();
        ((Model)this.getParentModel()).root().translateAndRotate(p_388896_);
        ModelPart modelpart = ((HeadedModel)this.getParentModel()).getHead();
        float f = modelpart.xRot;
        modelpart.xRot = Mth.clamp(modelpart.xRot, -0.5235988f, 1.5707964f);
        modelpart.translateAndRotate(p_388896_);
        modelpart.xRot = f;
        CustomHeadLayer.translateToHead(p_388896_, CustomHeadLayer.Transforms.DEFAULT);
        boolean flag = p_388092_ == HumanoidArm.LEFT;
        p_388896_.translate((flag ? -2.5f : 2.5f) / 16.0f, -0.0625f, 0.0f);
        p_386957_.render(p_388896_, p_386448_, p_388927_, OverlayTexture.NO_OVERLAY);
        p_388896_.popPose();
    }
}

