/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.IronGolemRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class IronGolemFlowerLayer
extends RenderLayer<IronGolemRenderState, IronGolemModel> {
    private final BlockRenderDispatcher blockRenderer;

    public IronGolemFlowerLayer(RenderLayerParent<IronGolemRenderState, IronGolemModel> p_234842_, BlockRenderDispatcher p_234843_) {
        super(p_234842_);
        this.blockRenderer = p_234843_;
    }

    @Override
    public void render(PoseStack p_117172_, MultiBufferSource p_117173_, int p_117174_, IronGolemRenderState p_364431_, float p_117176_, float p_117177_) {
        if (p_364431_.offerFlowerTick != 0) {
            p_117172_.pushPose();
            ModelPart modelpart = ((IronGolemModel)this.getParentModel()).getFlowerHoldingArm();
            modelpart.translateAndRotate(p_117172_);
            p_117172_.translate(-1.1875f, 1.0625f, -0.9375f);
            p_117172_.translate(0.5f, 0.5f, 0.5f);
            float f = 0.5f;
            p_117172_.scale(0.5f, 0.5f, 0.5f);
            p_117172_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            p_117172_.translate(-0.5f, -0.5f, -0.5f);
            this.blockRenderer.renderSingleBlock(Blocks.POPPY.defaultBlockState(), p_117172_, p_117173_, p_117174_, OverlayTexture.NO_OVERLAY);
            p_117172_.popPose();
        }
    }
}

