/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HorseRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.Markings;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseMarkingLayer
extends RenderLayer<HorseRenderState, HorseModel> {
    private static final ResourceLocation INVISIBLE_TEXTURE = ResourceLocation.withDefaultNamespace("invisible");
    private static final Map<Markings, ResourceLocation> LOCATION_BY_MARKINGS = Maps.newEnumMap(Map.of(Markings.NONE, INVISIBLE_TEXTURE, Markings.WHITE, ResourceLocation.withDefaultNamespace("textures/entity/horse/horse_markings_white.png"), Markings.WHITE_FIELD, ResourceLocation.withDefaultNamespace("textures/entity/horse/horse_markings_whitefield.png"), Markings.WHITE_DOTS, ResourceLocation.withDefaultNamespace("textures/entity/horse/horse_markings_whitedots.png"), Markings.BLACK_DOTS, ResourceLocation.withDefaultNamespace("textures/entity/horse/horse_markings_blackdots.png")));

    public HorseMarkingLayer(RenderLayerParent<HorseRenderState, HorseModel> p_117045_) {
        super(p_117045_);
    }

    @Override
    public void render(PoseStack p_117047_, MultiBufferSource p_117048_, int p_117049_, HorseRenderState p_365122_, float p_117051_, float p_117052_) {
        ResourceLocation resourcelocation = LOCATION_BY_MARKINGS.get((Object)p_365122_.markings);
        if (resourcelocation != INVISIBLE_TEXTURE && !p_365122_.isInvisible) {
            VertexConsumer vertexconsumer = p_117048_.getBuffer(RenderType.entityTranslucent(resourcelocation));
            ((HorseModel)this.getParentModel()).renderToBuffer(p_117047_, vertexconsumer, p_117049_, LivingEntityRenderer.getOverlayCoords(p_365122_, 0.0f));
        }
    }
}

