/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.AbstractMinecartRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.MinecartTntRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TntMinecartRenderer
extends AbstractMinecartRenderer<MinecartTNT, MinecartTntRenderState> {
    private final BlockRenderDispatcher blockRenderer;

    public TntMinecartRenderer(EntityRendererProvider.Context p_174424_) {
        super(p_174424_, ModelLayers.TNT_MINECART);
        this.blockRenderer = p_174424_.getBlockRenderDispatcher();
    }

    @Override
    protected void renderMinecartContents(MinecartTntRenderState p_363014_, BlockState p_116153_, PoseStack p_116154_, MultiBufferSource p_116155_, int p_116156_) {
        float f = p_363014_.fuseRemainingInTicks;
        if (f > -1.0f && f < 10.0f) {
            float f1 = 1.0f - f / 10.0f;
            f1 = Mth.clamp(f1, 0.0f, 1.0f);
            f1 *= f1;
            f1 *= f1;
            float f2 = 1.0f + f1 * 0.3f;
            p_116154_.scale(f2, f2, f2);
        }
        TntMinecartRenderer.renderWhiteSolidBlock(this.blockRenderer, p_116153_, p_116154_, p_116155_, p_116156_, f > -1.0f && (int)f / 5 % 2 == 0);
    }

    public static void renderWhiteSolidBlock(BlockRenderDispatcher p_234662_, BlockState p_234663_, PoseStack p_234664_, MultiBufferSource p_234665_, int p_234666_, boolean p_234667_) {
        int i = p_234667_ ? OverlayTexture.pack(OverlayTexture.u(1.0f), 10) : OverlayTexture.NO_OVERLAY;
        p_234662_.renderSingleBlock(p_234663_, p_234664_, p_234665_, p_234666_, i);
    }

    @Override
    public MinecartTntRenderState createRenderState() {
        return new MinecartTntRenderState();
    }

    @Override
    public void extractRenderState(MinecartTNT p_361891_, MinecartTntRenderState p_363447_, float p_364875_) {
        super.extractRenderState(p_361891_, p_363447_, p_364875_);
        p_363447_.fuseRemainingInTicks = p_361891_.getFuse() > -1 ? (float)p_361891_.getFuse() - p_364875_ + 1.0f : -1.0f;
    }
}

