/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.SquidRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Squid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class SquidRenderer<T extends Squid>
extends AgeableMobRenderer<T, SquidRenderState, SquidModel> {
    private static final ResourceLocation SQUID_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/squid/squid.png");

    public SquidRenderer(EntityRendererProvider.Context p_174406_, SquidModel p_174407_, SquidModel p_363623_) {
        super(p_174406_, p_174407_, p_363623_, 0.7f);
    }

    @Override
    public ResourceLocation getTextureLocation(SquidRenderState p_365407_) {
        return SQUID_LOCATION;
    }

    @Override
    public SquidRenderState createRenderState() {
        return new SquidRenderState();
    }

    @Override
    public void extractRenderState(T p_365335_, SquidRenderState p_360822_, float p_363384_) {
        super.extractRenderState(p_365335_, p_360822_, p_363384_);
        p_360822_.tentacleAngle = Mth.lerp(p_363384_, ((Squid)p_365335_).oldTentacleAngle, ((Squid)p_365335_).tentacleAngle);
        p_360822_.xBodyRot = Mth.lerp(p_363384_, ((Squid)p_365335_).xBodyRotO, ((Squid)p_365335_).xBodyRot);
        p_360822_.zBodyRot = Mth.lerp(p_363384_, ((Squid)p_365335_).zBodyRotO, ((Squid)p_365335_).zBodyRot);
    }

    @Override
    protected void setupRotations(SquidRenderState p_360924_, PoseStack p_116025_, float p_116026_, float p_116027_) {
        p_116025_.translate(0.0f, p_360924_.isBaby ? 0.25f : 0.5f, 0.0f);
        p_116025_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - p_116026_));
        p_116025_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(p_360924_.xBodyRot));
        p_116025_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(p_360924_.zBodyRot));
        p_116025_.translate(0.0f, p_360924_.isBaby ? -0.6f : -1.2f, 0.0f);
    }
}

