/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.ColdPigModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.SimpleEquipmentLayer;
import net.minecraft.client.renderer.entity.state.PigRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PigVariant;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PigRenderer
extends MobRenderer<Pig, PigRenderState, PigModel> {
    private final Map<PigVariant.ModelType, AdultAndBabyModelPair<PigModel>> models;

    public PigRenderer(EntityRendererProvider.Context p_174340_) {
        super(p_174340_, new PigModel(p_174340_.bakeLayer(ModelLayers.PIG)), 0.7f);
        this.models = PigRenderer.bakeModels(p_174340_);
        this.addLayer(new SimpleEquipmentLayer<PigRenderState, PigModel, PigModel>(this, p_174340_.getEquipmentRenderer(), EquipmentClientInfo.LayerType.PIG_SADDLE, p_397421_ -> p_397421_.saddle, new PigModel(p_174340_.bakeLayer(ModelLayers.PIG_SADDLE)), new PigModel(p_174340_.bakeLayer(ModelLayers.PIG_BABY_SADDLE))));
    }

    private static Map<PigVariant.ModelType, AdultAndBabyModelPair<PigModel>> bakeModels(EntityRendererProvider.Context p_394673_) {
        return Maps.newEnumMap(Map.of(PigVariant.ModelType.NORMAL, new AdultAndBabyModelPair<PigModel>(new PigModel(p_394673_.bakeLayer(ModelLayers.PIG)), new PigModel(p_394673_.bakeLayer(ModelLayers.PIG_BABY))), PigVariant.ModelType.COLD, new AdultAndBabyModelPair<ColdPigModel>(new ColdPigModel(p_394673_.bakeLayer(ModelLayers.COLD_PIG)), new ColdPigModel(p_394673_.bakeLayer(ModelLayers.COLD_PIG_BABY)))));
    }

    @Override
    public void render(PigRenderState p_393990_, PoseStack p_393537_, MultiBufferSource p_394350_, int p_394258_) {
        if (p_393990_.variant != null) {
            this.model = this.models.get(p_393990_.variant.modelAndTexture().model()).getModel(p_393990_.isBaby);
            super.render(p_393990_, p_393537_, p_394350_, p_394258_);
        }
    }

    @Override
    public ResourceLocation getTextureLocation(PigRenderState p_363187_) {
        return p_363187_.variant == null ? MissingTextureAtlasSprite.getLocation() : p_363187_.variant.modelAndTexture().asset().texturePath();
    }

    @Override
    public PigRenderState createRenderState() {
        return new PigRenderState();
    }

    @Override
    public void extractRenderState(Pig p_365526_, PigRenderState p_364366_, float p_361960_) {
        super.extractRenderState(p_365526_, p_364366_, p_361960_);
        p_364366_.saddle = p_365526_.getItemBySlot(EquipmentSlot.SADDLE).copy();
        p_364366_.variant = p_365526_.getVariant().value();
    }
}

